/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet;

import io.micronaut.oraclecloud.atp.wallet.ConnectionDescriptor;
import io.micronaut.oraclecloud.atp.wallet.TNSNames;
import io.micronaut.oraclecloud.atp.wallet.Wallet;
import io.micronaut.oraclecloud.atp.wallet.datasource.CanConfigureOracleDataSource;
import io.micronaut.oraclecloud.atp.wallet.datasource.OracleDataSourceAttributes;
import java.io.IOException;
import java.util.Objects;

public class WalletArchive
implements CanConfigureOracleDataSource {
    private final Wallet wallet;
    private final TNSNames tnsNames;

    WalletArchive(Wallet wallet, TNSNames tnsNames) {
        Objects.requireNonNull(wallet);
        this.wallet = wallet;
        this.tnsNames = tnsNames;
    }

    public String serviceAlias() {
        return this.wallet.serviceAlias();
    }

    public WalletArchive with(String serviceAlias) {
        return new WalletArchive(this.wallet.with(serviceAlias), this.tnsNames);
    }

    @Override
    public <T extends OracleDataSourceAttributes> T configure(T dataSource) throws IOException {
        ConnectionDescriptor connectionDescriptor;
        String serviceAlias;
        this.wallet.configure(dataSource);
        if (this.tnsNames != null && (serviceAlias = this.wallet.serviceAlias()) != null && (connectionDescriptor = this.tnsNames.connectionDescriptor(serviceAlias)) != null) {
            connectionDescriptor.configure(dataSource);
        }
        return dataSource;
    }
}

