/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet;

import io.micronaut.oraclecloud.atp.wallet.ByteStreams;
import io.micronaut.oraclecloud.atp.wallet.OracleWallets;
import io.micronaut.oraclecloud.atp.wallet.Wallets;
import io.micronaut.oraclecloud.atp.wallet.ZipArchives;

public class WalletModule {
    private static final WalletModule INSTANCE = new WalletModule(new ByteStreams());
    private final ByteStreams streams;
    private final OracleWallets oracleWallets;
    private final ZipArchives zipArchives;
    private final Wallets wallets;

    private WalletModule(ByteStreams streams) {
        this.streams = streams;
        this.oracleWallets = new OracleWallets(this.streams());
        this.zipArchives = new ZipArchives(streams);
        this.wallets = new Wallets(this.streams(), this.oracleWallets(), this.zipArchives());
    }

    public static WalletModule instance() {
        return INSTANCE;
    }

    ByteStreams streams() {
        return this.streams;
    }

    OracleWallets oracleWallets() {
        return this.oracleWallets;
    }

    ZipArchives zipArchives() {
        return this.zipArchives;
    }

    public Wallets wallets() {
        return this.wallets;
    }
}

