/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet.datasource;

import io.micronaut.oraclecloud.atp.wallet.datasource.OracleDataSourceAttributes;
import java.sql.SQLException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import oracle.jdbc.datasource.OracleCommonDataSource;

class OracleDataSourceAttributesBase<T extends OracleDataSourceAttributes>
implements OracleDataSourceAttributes<T> {
    protected SSLContext sslContext;
    protected String url;
    protected String user;
    protected char[] password;

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public T sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return (T)this;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public T url(String url) {
        this.url = url;
        return (T)this;
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    public T user(String user) {
        this.user = user;
        return (T)this;
    }

    @Override
    public char[] password() {
        if (this.password == null) {
            return null;
        }
        return Arrays.copyOf(this.password, this.password.length);
    }

    @Override
    public T password(char[] password) {
        if (password == null) {
            this.erase(this.password);
            this.password = null;
        } else {
            this.password = Arrays.copyOf(password, password.length);
        }
        return (T)this;
    }

    private void erase(char[] text) {
        if (text != null) {
            Arrays.fill(text, '*');
        }
    }

    static class Configurator<T extends OracleCommonDataSource>
    extends OracleDataSourceAttributesBase<Configurator<T>>
    implements OracleDataSourceAttributes<Configurator<T>> {
        private final T dataSource;

        Configurator(T dataSource) {
            this.dataSource = dataSource;
        }

        public T configure() throws SQLException {
            if (this.sslContext != null) {
                this.dataSource.setSSLContext(this.sslContext);
            }
            if (this.url != null) {
                this.dataSource.setURL(this.url);
            }
            if (this.user != null) {
                this.dataSource.setUser(this.url);
            }
            if (this.password != null) {
                this.dataSource.setPassword(new String(this.password));
            }
            return this.dataSource;
        }
    }
}

