/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.jdbc;

import com.oracle.bmc.database.Database;
import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.GenerateAutonomousDatabaseWalletDetails;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseRequest;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.StringUtils;
import io.micronaut.oraclecloud.atp.jdbc.AutonomousDatabaseConfiguration;
import io.micronaut.oraclecloud.atp.wallet.WalletModule;
import io.micronaut.oraclecloud.atp.wallet.datasource.CanConfigureOracleDataSource;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(beans={DatabaseClient.class})
public class OracleWalletArchiveProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OracleWalletArchiveProvider.class);
    private final Database databaseClient;

    public OracleWalletArchiveProvider(Database databaseClient) {
        this.databaseClient = databaseClient;
    }

    public CanConfigureOracleDataSource loadWalletArchive(AutonomousDatabaseConfiguration autonomousDatabaseConfiguration) {
        GenerateAutonomousDatabaseWalletDetails.Builder builder = GenerateAutonomousDatabaseWalletDetails.builder().password(autonomousDatabaseConfiguration.getWalletPassword());
        if (autonomousDatabaseConfiguration.getWalletType() != null) {
            builder.generateType(autonomousDatabaseConfiguration.getWalletType());
        }
        GenerateAutonomousDatabaseWalletResponse walletResponse = this.databaseClient.generateAutonomousDatabaseWallet(GenerateAutonomousDatabaseWalletRequest.builder().autonomousDatabaseId(autonomousDatabaseConfiguration.getOcid()).generateAutonomousDatabaseWalletDetails(builder.build()).build());
        try {
            String serviceAlias = autonomousDatabaseConfiguration.getServiceAlias();
            if (StringUtils.isEmpty((CharSequence)serviceAlias)) {
                GetAutonomousDatabaseResponse getAutonomousDatabaseResponse = this.databaseClient.getAutonomousDatabase(GetAutonomousDatabaseRequest.builder().autonomousDatabaseId(autonomousDatabaseConfiguration.getOcid()).build());
                String dbName = getAutonomousDatabaseResponse.getAutonomousDatabase().getDbName();
                serviceAlias = String.format("%s_high", dbName);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Using default serviceAlias: " + serviceAlias);
                }
            }
            return WalletModule.instance().wallets().archives().read(walletResponse.getInputStream()).with(serviceAlias);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error creating Oracle Wallet from the response: " + e.getMessage(), (Throwable)e);
        }
    }
}

