/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.jdbc.hikari;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import io.micronaut.configuration.jdbc.hikari.DatasourceConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanInitializingEvent;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.oraclecloud.atp.jdbc.AutonomousDatabaseConfiguration;
import io.micronaut.oraclecloud.atp.jdbc.OracleWalletArchiveProvider;
import io.micronaut.oraclecloud.atp.wallet.datasource.CanConfigureOracleDataSource;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.jdbc.datasource.OracleCommonDataSource;
import oracle.jdbc.datasource.impl.OracleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(classes={DatasourceConfiguration.class}), @Requires(sdk=Requires.Sdk.JAVA, value="11")})
@Internal
public class HikariPoolConfigurationListener
implements BeanInitializedEventListener<DatasourceConfiguration>,
Ordered {
    public static final int POSITION = -2147483548;
    public static final String ORACLE_JDBC_ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    private static final Logger LOG = LoggerFactory.getLogger(HikariPoolConfigurationListener.class);
    private final OracleWalletArchiveProvider walletArchiveProvider;
    private final BeanLocator beanLocator;

    protected HikariPoolConfigurationListener(@Nullable OracleWalletArchiveProvider walletArchiveProvider, @NonNull BeanLocator beanLocator) {
        this.walletArchiveProvider = walletArchiveProvider;
        this.beanLocator = beanLocator;
    }

    public int getOrder() {
        return -2147483548;
    }

    public DatasourceConfiguration onInitialized(BeanInitializingEvent<DatasourceConfiguration> event) {
        DatasourceConfiguration bean = (DatasourceConfiguration)event.getBean();
        String beanName = bean.getName();
        AutonomousDatabaseConfiguration autonomousDatabaseConfiguration = this.beanLocator.findBean(AutonomousDatabaseConfiguration.class, Qualifiers.byName((String)beanName)).orElse(null);
        if (autonomousDatabaseConfiguration == null) {
            LOG.trace("No AutonomousDatabaseConfiguration for [{}] datasource", (Object)beanName);
        } else if (autonomousDatabaseConfiguration.getOcid() == null || autonomousDatabaseConfiguration.getWalletPassword() == null) {
            LOG.trace("Skipping configuration of Oracle Wallet due to missin ocid or wallet password in AutonomousDatabaseConfiguration for [{}] datasource", (Object)beanName);
        } else {
            if (this.walletArchiveProvider == null && !this.beanLocator.findBean(AbstractAuthenticationDetailsProvider.class).isPresent()) {
                LOG.error("Datasource configuration [{}] requires to have the OCI SDK authentication configured.", (Object)beanName);
                throw new NoSuchBeanException(OracleWalletArchiveProvider.class);
            }
            LOG.trace("Retrieving Oracle Wallet for DataSource [{}]", (Object)beanName);
            CanConfigureOracleDataSource walletArchive = this.walletArchiveProvider.loadWalletArchive(autonomousDatabaseConfiguration);
            try {
                OracleDataSource oracleDataSource = new OracleDataSource();
                walletArchive.configure((OracleCommonDataSource)oracleDataSource);
                bean.setDataSource((DataSource)oracleDataSource);
                bean.setUrl(oracleDataSource.getURL());
                bean.setDriverClassName(ORACLE_JDBC_ORACLE_DRIVER);
                Properties dataSourceProperties = bean.getDataSourceProperties();
                if (dataSourceProperties != null && !dataSourceProperties.isEmpty()) {
                    oracleDataSource.setConnectionProperties(dataSourceProperties);
                }
            }
            catch (IOException | SQLException e) {
                throw new ConfigurationException("Error configuring the [" + beanName + "] datasource: " + e.getMessage(), (Throwable)e);
            }
        }
        return bean;
    }
}

