/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.jdbc.upc;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import io.micronaut.configuration.jdbc.ucp.DatasourceConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanInitializingEvent;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.oraclecloud.atp.jdbc.AutonomousDatabaseConfiguration;
import io.micronaut.oraclecloud.atp.jdbc.OracleWalletArchiveProvider;
import io.micronaut.oraclecloud.atp.wallet.datasource.CanConfigureOracleDataSource;
import io.micronaut.oraclecloud.atp.wallet.datasource.OracleDataSourceAttributes;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.sql.SQLException;
import javax.net.ssl.SSLContext;
import oracle.ucp.jdbc.PoolDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(sdk=Requires.Sdk.JAVA, value="11"), @Requires(classes={PoolDataSource.class})})
@Internal
public class UcpPoolConfigurationListener
implements BeanInitializedEventListener<DatasourceConfiguration>,
Ordered {
    public static final int POSITION = -2147483548;
    private static final String ORACLE_JDBC_POOL_ORACLE_DATA_SOURCE = "oracle.jdbc.pool.OracleDataSource";
    private static final Logger LOG = LoggerFactory.getLogger(UcpPoolConfigurationListener.class);
    private final OracleWalletArchiveProvider walletArchiveProvider;
    private final BeanLocator beanLocator;

    protected UcpPoolConfigurationListener(@Nullable OracleWalletArchiveProvider walletArchiveProvider, @NonNull BeanLocator beanLocator) {
        this.walletArchiveProvider = walletArchiveProvider;
        this.beanLocator = beanLocator;
    }

    public int getOrder() {
        return -2147483548;
    }

    public DatasourceConfiguration onInitialized(BeanInitializingEvent<DatasourceConfiguration> event) {
        final DatasourceConfiguration bean = (DatasourceConfiguration)event.getBean();
        String beanName = bean.getName();
        AutonomousDatabaseConfiguration autonomousDatabaseConfiguration = this.beanLocator.findBean(AutonomousDatabaseConfiguration.class, Qualifiers.byName((String)beanName)).orElse(null);
        if (autonomousDatabaseConfiguration == null) {
            LOG.trace("No AutonomousDatabaseConfiguration for [{}] datasource", (Object)beanName);
        } else if (autonomousDatabaseConfiguration.getOcid() == null || autonomousDatabaseConfiguration.getWalletPassword() == null) {
            LOG.trace("Skipping configuration of Oracle Wallet due to missing ocid or wallet password in AutonomousDatabaseConfiguration for [{}] datasource", (Object)beanName);
        } else {
            if (this.walletArchiveProvider == null && !this.beanLocator.findBean(AbstractAuthenticationDetailsProvider.class).isPresent()) {
                LOG.error("Datasource configuration [{}] requires to have the OCI SDK authentication configured.", (Object)beanName);
                throw new NoSuchBeanException(OracleWalletArchiveProvider.class);
            }
            LOG.trace("Retrieving Oracle Wallet for DataSource [{}]", (Object)beanName);
            CanConfigureOracleDataSource walletArchive = this.walletArchiveProvider.loadWalletArchive(autonomousDatabaseConfiguration);
            try {
                if (StringUtils.isEmpty((CharSequence)bean.getConfiguredDriverClassName())) {
                    LOG.debug("Configured connection factory oracle.jdbc.pool.OracleDataSource for [{}] datasource", (Object)beanName);
                    bean.setDriverClassName(ORACLE_JDBC_POOL_ORACLE_DATA_SOURCE);
                }
                walletArchive.configure(new OracleDataSourceAttributes(){
                    private SSLContext sslContext;

                    @Override
                    public SSLContext sslContext() {
                        return this.sslContext;
                    }

                    public OracleDataSourceAttributes sslContext(SSLContext sslContext) {
                        this.sslContext = sslContext;
                        bean.getPoolDataSource().setSSLContext(sslContext);
                        return this;
                    }

                    @Override
                    public String url() {
                        return null;
                    }

                    public OracleDataSourceAttributes url(String url) {
                        bean.setUrl(url);
                        return this;
                    }

                    @Override
                    public String user() {
                        return bean.getUsername();
                    }

                    public OracleDataSourceAttributes user(String user) {
                        bean.setUsername(user);
                        return this;
                    }

                    @Override
                    public char[] password() {
                        if (bean.getPassword() != null) {
                            return bean.getPassword().toCharArray();
                        }
                        return null;
                    }

                    public OracleDataSourceAttributes password(char[] password) {
                        bean.setPassword(String.valueOf(password));
                        return this;
                    }
                });
                LOG.debug("Successfully configured OracleWallet for [{}] datasource", (Object)beanName);
            }
            catch (IOException | SQLException e) {
                throw new ConfigurationException("Error configuring the [" + beanName + "] datasource: " + e.getMessage(), (Throwable)e);
            }
        }
        return bean;
    }
}

