/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet;

import io.micronaut.oraclecloud.atp.wallet.ByteStreams;
import io.micronaut.oraclecloud.atp.wallet.OracleWallets;
import io.micronaut.oraclecloud.atp.wallet.TNSNames;
import io.micronaut.oraclecloud.atp.wallet.Wallet;
import io.micronaut.oraclecloud.atp.wallet.WalletArchive;
import io.micronaut.oraclecloud.atp.wallet.ZipArchive;
import io.micronaut.oraclecloud.atp.wallet.ZipArchives;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.security.pki.OracleWallet;

public class Wallets {
    private static final String CWALLET_SSO = "cwallet.sso";
    private static final String EWALLET_P12 = "ewallet.p12";
    private final OracleWallets wallets;
    private final ByteStreams streams;
    private final Archives archives;

    Wallets(ByteStreams streams, OracleWallets wallets, ZipArchives zipArchives) {
        this.streams = streams;
        this.wallets = wallets;
        this.archives = new Archives(zipArchives);
    }

    public Wallet.Builder builder() throws IOException {
        OracleWallet wallet = new OracleWallet();
        wallet.createSSO();
        return Wallet.Builder.of(wallet);
    }

    public Wallet.Builder modify(Wallet wallet) throws IOException {
        return this.modify(wallet, null);
    }

    public Wallet.Builder modify(Wallet wallet, char[] password) throws IOException {
        return Wallet.Builder.of(this.wallets.copy(wallet.wallet, password));
    }

    public Wallet read(InputStream content) throws IOException {
        OracleWallet autoLoginWallet = this.wallets.read(this.streams.asByteArray(content), null);
        Wallet wallet = Wallet.of(autoLoginWallet);
        return wallet;
    }

    public Wallet read(Path wallet) throws IOException {
        if (Files.isDirectory(wallet, new LinkOption[0])) {
            Path autoLoginWallet = wallet.resolve(CWALLET_SSO);
            return this.readWallet(autoLoginWallet);
        }
        return this.readWallet(wallet);
    }

    private Wallet readWallet(Path wallet) throws IOException {
        try (InputStream content = Files.newInputStream(wallet, new OpenOption[0]);){
            Wallet wallet2 = this.read(content);
            return wallet2;
        }
    }

    public Wallet read(Path wallet, char[] password) throws IOException {
        if (Files.isDirectory(wallet, new LinkOption[0])) {
            Path passwordProtectedWallet = wallet.resolve(EWALLET_P12);
            return this.readWallet(passwordProtectedWallet);
        }
        return this.readWallet(wallet, password);
    }

    private Wallet readWallet(Path wallet, char[] password) throws IOException {
        try (InputStream content = Files.newInputStream(wallet, new OpenOption[0]);){
            Wallet wallet2 = this.read(content, password);
            return wallet2;
        }
    }

    public Archives archives() {
        return this.archives;
    }

    public Wallet read(InputStream content, char[] password) throws IOException {
        OracleWallet passwordProtectedWallet = this.wallets.read(this.streams.asByteArray(content), password);
        Wallet wallet = Wallet.of(passwordProtectedWallet);
        return wallet;
    }

    public class Archives {
        private final ZipArchives zipArchives;

        Archives(ZipArchives zipArchives) {
            this.zipArchives = zipArchives;
        }

        public WalletArchive read(Path path) throws IOException {
            return this.read(path, null);
        }

        public WalletArchive read(Path path, char[] password) throws IOException {
            ZipArchive zip = this.zipArchives.of(path);
            return this.walletArchive(zip, password);
        }

        public WalletArchive read(InputStream content) throws IOException {
            return this.read(content, null);
        }

        public WalletArchive read(InputStream content, char[] password) throws IOException {
            ZipArchive zip = this.zipArchives.of(content);
            return this.walletArchive(zip, password);
        }

        private WalletArchive walletArchive(ZipArchive archive, char[] password) throws IOException {
            String walletName = password == null ? Wallets.CWALLET_SSO : Wallets.EWALLET_P12;
            Wallet wallet = null;
            TNSNames tnsNames = null;
            try (ZipInputStream zip = archive.toZipInputStream();){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    InputStream entryContent = Wallets.this.streams.uncloseable(zip);
                    String entryName = entry.getName();
                    if (walletName.equalsIgnoreCase(entryName)) {
                        wallet = Wallets.this.read(entryContent, password);
                    } else if ("tnsnames.ora".equalsIgnoreCase(entryName)) {
                        tnsNames = TNSNames.read(entryContent);
                    }
                    entry = zip.getNextEntry();
                }
            }
            return new WalletArchive(wallet, tnsNames);
        }
    }
}

