/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.accessgovernancecp;

import com.oracle.bmc.accessgovernancecp.AccessGovernanceCPAsyncClient;
import com.oracle.bmc.accessgovernancecp.requests.ChangeGovernanceInstanceCompartmentRequest;
import com.oracle.bmc.accessgovernancecp.requests.CreateGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.DeleteGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.GetGovernanceInstanceConfigurationRequest;
import com.oracle.bmc.accessgovernancecp.requests.GetGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.ListGovernanceInstancesRequest;
import com.oracle.bmc.accessgovernancecp.requests.UpdateGovernanceInstanceConfigurationRequest;
import com.oracle.bmc.accessgovernancecp.requests.UpdateGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.responses.ChangeGovernanceInstanceCompartmentResponse;
import com.oracle.bmc.accessgovernancecp.responses.CreateGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.DeleteGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.GetGovernanceInstanceConfigurationResponse;
import com.oracle.bmc.accessgovernancecp.responses.GetGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.ListGovernanceInstancesResponse;
import com.oracle.bmc.accessgovernancecp.responses.UpdateGovernanceInstanceConfigurationResponse;
import com.oracle.bmc.accessgovernancecp.responses.UpdateGovernanceInstanceResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={AccessGovernanceCPAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AccessGovernanceCPReactorClient {
    AccessGovernanceCPAsyncClient client;

    AccessGovernanceCPReactorClient(AccessGovernanceCPAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeGovernanceInstanceCompartmentResponse> changeGovernanceInstanceCompartment(ChangeGovernanceInstanceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeGovernanceInstanceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateGovernanceInstanceResponse> createGovernanceInstance(CreateGovernanceInstanceRequest request) {
        return Mono.create(sink -> this.client.createGovernanceInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteGovernanceInstanceResponse> deleteGovernanceInstance(DeleteGovernanceInstanceRequest request) {
        return Mono.create(sink -> this.client.deleteGovernanceInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetGovernanceInstanceResponse> getGovernanceInstance(GetGovernanceInstanceRequest request) {
        return Mono.create(sink -> this.client.getGovernanceInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetGovernanceInstanceConfigurationResponse> getGovernanceInstanceConfiguration(GetGovernanceInstanceConfigurationRequest request) {
        return Mono.create(sink -> this.client.getGovernanceInstanceConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListGovernanceInstancesResponse> listGovernanceInstances(ListGovernanceInstancesRequest request) {
        return Mono.create(sink -> this.client.listGovernanceInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateGovernanceInstanceResponse> updateGovernanceInstance(UpdateGovernanceInstanceRequest request) {
        return Mono.create(sink -> this.client.updateGovernanceInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateGovernanceInstanceConfigurationResponse> updateGovernanceInstanceConfiguration(UpdateGovernanceInstanceConfigurationRequest request) {
        return Mono.create(sink -> this.client.updateGovernanceInstanceConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

