/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.apmtraces;

import com.oracle.bmc.apmtraces.QueryAsyncClient;
import com.oracle.bmc.apmtraces.requests.ListQuickPicksRequest;
import com.oracle.bmc.apmtraces.requests.QueryRequest;
import com.oracle.bmc.apmtraces.responses.ListQuickPicksResponse;
import com.oracle.bmc.apmtraces.responses.QueryResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={QueryAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class QueryReactorClient {
    QueryAsyncClient client;

    QueryReactorClient(QueryAsyncClient client) {
        this.client = client;
    }

    public Mono<ListQuickPicksResponse> listQuickPicks(ListQuickPicksRequest request) {
        return Mono.create(sink -> this.client.listQuickPicks(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<QueryResponse> query(QueryRequest request) {
        return Mono.create(sink -> this.client.query(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

