/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.apmtraces;

import com.oracle.bmc.apmtraces.TraceAsyncClient;
import com.oracle.bmc.apmtraces.requests.GetAggregatedSnapshotRequest;
import com.oracle.bmc.apmtraces.requests.GetSpanRequest;
import com.oracle.bmc.apmtraces.requests.GetTraceRequest;
import com.oracle.bmc.apmtraces.requests.GetTraceSnapshotRequest;
import com.oracle.bmc.apmtraces.responses.GetAggregatedSnapshotResponse;
import com.oracle.bmc.apmtraces.responses.GetSpanResponse;
import com.oracle.bmc.apmtraces.responses.GetTraceResponse;
import com.oracle.bmc.apmtraces.responses.GetTraceSnapshotResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={TraceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class TraceReactorClient {
    TraceAsyncClient client;

    TraceReactorClient(TraceAsyncClient client) {
        this.client = client;
    }

    public Mono<GetAggregatedSnapshotResponse> getAggregatedSnapshot(GetAggregatedSnapshotRequest request) {
        return Mono.create(sink -> this.client.getAggregatedSnapshot(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSpanResponse> getSpan(GetSpanRequest request) {
        return Mono.create(sink -> this.client.getSpan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetTraceResponse> getTrace(GetTraceRequest request) {
        return Mono.create(sink -> this.client.getTrace(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetTraceSnapshotResponse> getTraceSnapshot(GetTraceSnapshotRequest request) {
        return Mono.create(sink -> this.client.getTraceSnapshot(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

