/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apmtraces;

import com.oracle.bmc.apmtraces.TraceAsyncClient;
import com.oracle.bmc.apmtraces.requests.GetAggregatedSnapshotRequest;
import com.oracle.bmc.apmtraces.requests.GetSpanRequest;
import com.oracle.bmc.apmtraces.requests.GetTraceRequest;
import com.oracle.bmc.apmtraces.requests.GetTraceSnapshotRequest;
import com.oracle.bmc.apmtraces.responses.GetAggregatedSnapshotResponse;
import com.oracle.bmc.apmtraces.responses.GetSpanResponse;
import com.oracle.bmc.apmtraces.responses.GetTraceResponse;
import com.oracle.bmc.apmtraces.responses.GetTraceSnapshotResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={TraceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class TraceRxClient {
    TraceAsyncClient client;

    TraceRxClient(TraceAsyncClient client) {
        this.client = client;
    }

    public Single<GetAggregatedSnapshotResponse> getAggregatedSnapshot(GetAggregatedSnapshotRequest request) {
        return Single.create(emitter -> this.client.getAggregatedSnapshot(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSpanResponse> getSpan(GetSpanRequest request) {
        return Single.create(emitter -> this.client.getSpan(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTraceResponse> getTrace(GetTraceRequest request) {
        return Single.create(emitter -> this.client.getTrace(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTraceSnapshotResponse> getTraceSnapshot(GetTraceSnapshotRequest request) {
        return Single.create(emitter -> this.client.getTraceSnapshot(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

