/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.appmgmtcontrol;

import com.oracle.bmc.appmgmtcontrol.AppmgmtControlAsyncClient;
import com.oracle.bmc.appmgmtcontrol.requests.ActivateMonitoringPluginRequest;
import com.oracle.bmc.appmgmtcontrol.requests.GetMonitoredInstanceRequest;
import com.oracle.bmc.appmgmtcontrol.requests.GetWorkRequestRequest;
import com.oracle.bmc.appmgmtcontrol.requests.ListMonitoredInstancesRequest;
import com.oracle.bmc.appmgmtcontrol.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.appmgmtcontrol.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.appmgmtcontrol.requests.ListWorkRequestsRequest;
import com.oracle.bmc.appmgmtcontrol.requests.PublishTopProcessesMetricsRequest;
import com.oracle.bmc.appmgmtcontrol.responses.ActivateMonitoringPluginResponse;
import com.oracle.bmc.appmgmtcontrol.responses.GetMonitoredInstanceResponse;
import com.oracle.bmc.appmgmtcontrol.responses.GetWorkRequestResponse;
import com.oracle.bmc.appmgmtcontrol.responses.ListMonitoredInstancesResponse;
import com.oracle.bmc.appmgmtcontrol.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.appmgmtcontrol.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.appmgmtcontrol.responses.ListWorkRequestsResponse;
import com.oracle.bmc.appmgmtcontrol.responses.PublishTopProcessesMetricsResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={AppmgmtControlAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AppmgmtControlReactorClient {
    AppmgmtControlAsyncClient client;

    AppmgmtControlReactorClient(AppmgmtControlAsyncClient client) {
        this.client = client;
    }

    public Mono<ActivateMonitoringPluginResponse> activateMonitoringPlugin(ActivateMonitoringPluginRequest request) {
        return Mono.create(sink -> this.client.activateMonitoringPlugin(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetMonitoredInstanceResponse> getMonitoredInstance(GetMonitoredInstanceRequest request) {
        return Mono.create(sink -> this.client.getMonitoredInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListMonitoredInstancesResponse> listMonitoredInstances(ListMonitoredInstancesRequest request) {
        return Mono.create(sink -> this.client.listMonitoredInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<PublishTopProcessesMetricsResponse> publishTopProcessesMetrics(PublishTopProcessesMetricsRequest request) {
        return Mono.create(sink -> this.client.publishTopProcessesMetrics(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

