/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.containerinstances;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.containerinstances.ContainerInstanceAsyncClient;
import com.oracle.bmc.containerinstances.requests.ChangeContainerInstanceCompartmentRequest;
import com.oracle.bmc.containerinstances.requests.CreateContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.DeleteContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.GetContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.GetContainerRequest;
import com.oracle.bmc.containerinstances.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerinstances.requests.ListContainerInstanceShapesRequest;
import com.oracle.bmc.containerinstances.requests.ListContainerInstancesRequest;
import com.oracle.bmc.containerinstances.requests.ListContainersRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerinstances.requests.RestartContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.RetrieveLogsRequest;
import com.oracle.bmc.containerinstances.requests.StartContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.StopContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.UpdateContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.UpdateContainerRequest;
import com.oracle.bmc.containerinstances.responses.ChangeContainerInstanceCompartmentResponse;
import com.oracle.bmc.containerinstances.responses.CreateContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.DeleteContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.GetContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.GetContainerResponse;
import com.oracle.bmc.containerinstances.responses.GetWorkRequestResponse;
import com.oracle.bmc.containerinstances.responses.ListContainerInstanceShapesResponse;
import com.oracle.bmc.containerinstances.responses.ListContainerInstancesResponse;
import com.oracle.bmc.containerinstances.responses.ListContainersResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerinstances.responses.RestartContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.RetrieveLogsResponse;
import com.oracle.bmc.containerinstances.responses.StartContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.StopContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.UpdateContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.UpdateContainerResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ContainerInstanceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ContainerInstanceReactorClient {
    ContainerInstanceAsyncClient client;

    ContainerInstanceReactorClient(ContainerInstanceAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeContainerInstanceCompartmentResponse> changeContainerInstanceCompartment(ChangeContainerInstanceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeContainerInstanceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateContainerInstanceResponse> createContainerInstance(CreateContainerInstanceRequest request) {
        return Mono.create(sink -> this.client.createContainerInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteContainerInstanceResponse> deleteContainerInstance(DeleteContainerInstanceRequest request) {
        return Mono.create(sink -> this.client.deleteContainerInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetContainerResponse> getContainer(GetContainerRequest request) {
        return Mono.create(sink -> this.client.getContainer(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetContainerInstanceResponse> getContainerInstance(GetContainerInstanceRequest request) {
        return Mono.create(sink -> this.client.getContainerInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListContainerInstanceShapesResponse> listContainerInstanceShapes(ListContainerInstanceShapesRequest request) {
        return Mono.create(sink -> this.client.listContainerInstanceShapes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListContainerInstancesResponse> listContainerInstances(ListContainerInstancesRequest request) {
        return Mono.create(sink -> this.client.listContainerInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListContainersResponse> listContainers(ListContainersRequest request) {
        return Mono.create(sink -> this.client.listContainers(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RestartContainerInstanceResponse> restartContainerInstance(RestartContainerInstanceRequest request) {
        return Mono.create(sink -> this.client.restartContainerInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RetrieveLogsResponse> retrieveLogs(RetrieveLogsRequest request) {
        return Mono.create(sink -> this.client.retrieveLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StartContainerInstanceResponse> startContainerInstance(StartContainerInstanceRequest request) {
        return Mono.create(sink -> this.client.startContainerInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StopContainerInstanceResponse> stopContainerInstance(StopContainerInstanceRequest request) {
        return Mono.create(sink -> this.client.stopContainerInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateContainerResponse> updateContainer(UpdateContainerRequest request) {
        return Mono.create(sink -> this.client.updateContainer(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateContainerInstanceResponse> updateContainerInstance(UpdateContainerInstanceRequest request) {
        return Mono.create(sink -> this.client.updateContainerInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

