/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.functions;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.functions.FunctionsManagementAsyncClient;
import com.oracle.bmc.functions.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.functions.requests.CreateApplicationRequest;
import com.oracle.bmc.functions.requests.CreateFunctionRequest;
import com.oracle.bmc.functions.requests.DeleteApplicationRequest;
import com.oracle.bmc.functions.requests.DeleteFunctionRequest;
import com.oracle.bmc.functions.requests.GetApplicationRequest;
import com.oracle.bmc.functions.requests.GetFunctionRequest;
import com.oracle.bmc.functions.requests.GetPbfListingRequest;
import com.oracle.bmc.functions.requests.GetPbfListingVersionRequest;
import com.oracle.bmc.functions.requests.ListApplicationsRequest;
import com.oracle.bmc.functions.requests.ListFunctionsRequest;
import com.oracle.bmc.functions.requests.ListPbfListingVersionsRequest;
import com.oracle.bmc.functions.requests.ListPbfListingsRequest;
import com.oracle.bmc.functions.requests.ListTriggersRequest;
import com.oracle.bmc.functions.requests.UpdateApplicationRequest;
import com.oracle.bmc.functions.requests.UpdateFunctionRequest;
import com.oracle.bmc.functions.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.functions.responses.CreateApplicationResponse;
import com.oracle.bmc.functions.responses.CreateFunctionResponse;
import com.oracle.bmc.functions.responses.DeleteApplicationResponse;
import com.oracle.bmc.functions.responses.DeleteFunctionResponse;
import com.oracle.bmc.functions.responses.GetApplicationResponse;
import com.oracle.bmc.functions.responses.GetFunctionResponse;
import com.oracle.bmc.functions.responses.GetPbfListingResponse;
import com.oracle.bmc.functions.responses.GetPbfListingVersionResponse;
import com.oracle.bmc.functions.responses.ListApplicationsResponse;
import com.oracle.bmc.functions.responses.ListFunctionsResponse;
import com.oracle.bmc.functions.responses.ListPbfListingVersionsResponse;
import com.oracle.bmc.functions.responses.ListPbfListingsResponse;
import com.oracle.bmc.functions.responses.ListTriggersResponse;
import com.oracle.bmc.functions.responses.UpdateApplicationResponse;
import com.oracle.bmc.functions.responses.UpdateFunctionResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={FunctionsManagementAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class FunctionsManagementReactorClient {
    FunctionsManagementAsyncClient client;

    FunctionsManagementReactorClient(FunctionsManagementAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeApplicationCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateApplicationResponse> createApplication(CreateApplicationRequest request) {
        return Mono.create(sink -> this.client.createApplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateFunctionResponse> createFunction(CreateFunctionRequest request) {
        return Mono.create(sink -> this.client.createFunction(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request) {
        return Mono.create(sink -> this.client.deleteApplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest request) {
        return Mono.create(sink -> this.client.deleteFunction(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetApplicationResponse> getApplication(GetApplicationRequest request) {
        return Mono.create(sink -> this.client.getApplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetFunctionResponse> getFunction(GetFunctionRequest request) {
        return Mono.create(sink -> this.client.getFunction(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetPbfListingResponse> getPbfListing(GetPbfListingRequest request) {
        return Mono.create(sink -> this.client.getPbfListing(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetPbfListingVersionResponse> getPbfListingVersion(GetPbfListingVersionRequest request) {
        return Mono.create(sink -> this.client.getPbfListingVersion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListApplicationsResponse> listApplications(ListApplicationsRequest request) {
        return Mono.create(sink -> this.client.listApplications(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListFunctionsResponse> listFunctions(ListFunctionsRequest request) {
        return Mono.create(sink -> this.client.listFunctions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListPbfListingVersionsResponse> listPbfListingVersions(ListPbfListingVersionsRequest request) {
        return Mono.create(sink -> this.client.listPbfListingVersions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListPbfListingsResponse> listPbfListings(ListPbfListingsRequest request) {
        return Mono.create(sink -> this.client.listPbfListings(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListTriggersResponse> listTriggers(ListTriggersRequest request) {
        return Mono.create(sink -> this.client.listTriggers(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request) {
        return Mono.create(sink -> this.client.updateApplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest request) {
        return Mono.create(sink -> this.client.updateFunction(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

