/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.genericartifactscontent;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.genericartifactscontent.GenericArtifactsContentAsyncClient;
import com.oracle.bmc.genericartifactscontent.requests.GetGenericArtifactContentByPathRequest;
import com.oracle.bmc.genericartifactscontent.requests.GetGenericArtifactContentRequest;
import com.oracle.bmc.genericartifactscontent.requests.PutGenericArtifactContentByPathRequest;
import com.oracle.bmc.genericartifactscontent.responses.GetGenericArtifactContentByPathResponse;
import com.oracle.bmc.genericartifactscontent.responses.GetGenericArtifactContentResponse;
import com.oracle.bmc.genericartifactscontent.responses.PutGenericArtifactContentByPathResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={GenericArtifactsContentAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class GenericArtifactsContentReactorClient {
    GenericArtifactsContentAsyncClient client;

    GenericArtifactsContentReactorClient(GenericArtifactsContentAsyncClient client) {
        this.client = client;
    }

    public Mono<GetGenericArtifactContentResponse> getGenericArtifactContent(GetGenericArtifactContentRequest request) {
        return Mono.create(sink -> this.client.getGenericArtifactContent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetGenericArtifactContentByPathResponse> getGenericArtifactContentByPath(GetGenericArtifactContentByPathRequest request) {
        return Mono.create(sink -> this.client.getGenericArtifactContentByPath(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<PutGenericArtifactContentByPathResponse> putGenericArtifactContentByPath(PutGenericArtifactContentByPathRequest request) {
        return Mono.create(sink -> this.client.putGenericArtifactContentByPath(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

