/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.opa;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.opa.OpaInstanceAsyncClient;
import com.oracle.bmc.opa.requests.CancelWorkRequestRequest;
import com.oracle.bmc.opa.requests.ChangeOpaInstanceCompartmentRequest;
import com.oracle.bmc.opa.requests.CreateOpaInstanceRequest;
import com.oracle.bmc.opa.requests.DeleteOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetWorkRequestRequest;
import com.oracle.bmc.opa.requests.ListOpaInstancesRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestsRequest;
import com.oracle.bmc.opa.requests.UpdateOpaInstanceRequest;
import com.oracle.bmc.opa.responses.CancelWorkRequestResponse;
import com.oracle.bmc.opa.responses.ChangeOpaInstanceCompartmentResponse;
import com.oracle.bmc.opa.responses.CreateOpaInstanceResponse;
import com.oracle.bmc.opa.responses.DeleteOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetWorkRequestResponse;
import com.oracle.bmc.opa.responses.ListOpaInstancesResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestsResponse;
import com.oracle.bmc.opa.responses.UpdateOpaInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={OpaInstanceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OpaInstanceReactorClient {
    OpaInstanceAsyncClient client;

    OpaInstanceReactorClient(OpaInstanceAsyncClient client) {
        this.client = client;
    }

    public Mono<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Mono.create(sink -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeOpaInstanceCompartmentResponse> changeOpaInstanceCompartment(ChangeOpaInstanceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeOpaInstanceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateOpaInstanceResponse> createOpaInstance(CreateOpaInstanceRequest request) {
        return Mono.create(sink -> this.client.createOpaInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteOpaInstanceResponse> deleteOpaInstance(DeleteOpaInstanceRequest request) {
        return Mono.create(sink -> this.client.deleteOpaInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetOpaInstanceResponse> getOpaInstance(GetOpaInstanceRequest request) {
        return Mono.create(sink -> this.client.getOpaInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListOpaInstancesResponse> listOpaInstances(ListOpaInstancesRequest request) {
        return Mono.create(sink -> this.client.listOpaInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateOpaInstanceResponse> updateOpaInstance(UpdateOpaInstanceRequest request) {
        return Mono.create(sink -> this.client.updateOpaInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

