/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osmanagementhub;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagementhub.ManagementStationAsyncClient;
import com.oracle.bmc.osmanagementhub.requests.CreateManagementStationRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteManagementStationRequest;
import com.oracle.bmc.osmanagementhub.requests.GetManagementStationRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagementStationsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListMirrorsRequest;
import com.oracle.bmc.osmanagementhub.requests.SynchronizeMirrorsRequest;
import com.oracle.bmc.osmanagementhub.requests.SynchronizeSingleMirrorsRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateManagementStationRequest;
import com.oracle.bmc.osmanagementhub.responses.CreateManagementStationResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteManagementStationResponse;
import com.oracle.bmc.osmanagementhub.responses.GetManagementStationResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagementStationsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListMirrorsResponse;
import com.oracle.bmc.osmanagementhub.responses.SynchronizeMirrorsResponse;
import com.oracle.bmc.osmanagementhub.responses.SynchronizeSingleMirrorsResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateManagementStationResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ManagementStationAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ManagementStationReactorClient {
    ManagementStationAsyncClient client;

    ManagementStationReactorClient(ManagementStationAsyncClient client) {
        this.client = client;
    }

    public Mono<CreateManagementStationResponse> createManagementStation(CreateManagementStationRequest request) {
        return Mono.create(sink -> this.client.createManagementStation(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteManagementStationResponse> deleteManagementStation(DeleteManagementStationRequest request) {
        return Mono.create(sink -> this.client.deleteManagementStation(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetManagementStationResponse> getManagementStation(GetManagementStationRequest request) {
        return Mono.create(sink -> this.client.getManagementStation(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListManagementStationsResponse> listManagementStations(ListManagementStationsRequest request) {
        return Mono.create(sink -> this.client.listManagementStations(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListMirrorsResponse> listMirrors(ListMirrorsRequest request) {
        return Mono.create(sink -> this.client.listMirrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SynchronizeMirrorsResponse> synchronizeMirrors(SynchronizeMirrorsRequest request) {
        return Mono.create(sink -> this.client.synchronizeMirrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SynchronizeSingleMirrorsResponse> synchronizeSingleMirrors(SynchronizeSingleMirrorsRequest request) {
        return Mono.create(sink -> this.client.synchronizeSingleMirrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateManagementStationResponse> updateManagementStation(UpdateManagementStationRequest request) {
        return Mono.create(sink -> this.client.updateManagementStation(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

