/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osmanagementhub;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagementhub.OnboardingAsyncClient;
import com.oracle.bmc.osmanagementhub.requests.CreateProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.GetProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.ListProfilesRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateProfileRequest;
import com.oracle.bmc.osmanagementhub.responses.CreateProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.GetProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.ListProfilesResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateProfileResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={OnboardingAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OnboardingReactorClient {
    OnboardingAsyncClient client;

    OnboardingReactorClient(OnboardingAsyncClient client) {
        this.client = client;
    }

    public Mono<CreateProfileResponse> createProfile(CreateProfileRequest request) {
        return Mono.create(sink -> this.client.createProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteProfileResponse> deleteProfile(DeleteProfileRequest request) {
        return Mono.create(sink -> this.client.deleteProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetProfileResponse> getProfile(GetProfileRequest request) {
        return Mono.create(sink -> this.client.getProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListProfilesResponse> listProfiles(ListProfilesRequest request) {
        return Mono.create(sink -> this.client.listProfiles(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateProfileResponse> updateProfile(UpdateProfileRequest request) {
        return Mono.create(sink -> this.client.updateProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

