/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osmanagementhub;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagementhub.ReportingManagedInstanceAsyncClient;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceAnalyticContentRequest;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceContentRequest;
import com.oracle.bmc.osmanagementhub.requests.SummarizeManagedInstanceAnalyticsRequest;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceAnalyticContentResponse;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceContentResponse;
import com.oracle.bmc.osmanagementhub.responses.SummarizeManagedInstanceAnalyticsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ReportingManagedInstanceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ReportingManagedInstanceReactorClient {
    ReportingManagedInstanceAsyncClient client;

    ReportingManagedInstanceReactorClient(ReportingManagedInstanceAsyncClient client) {
        this.client = client;
    }

    public Mono<GetManagedInstanceAnalyticContentResponse> getManagedInstanceAnalyticContent(GetManagedInstanceAnalyticContentRequest request) {
        return Mono.create(sink -> this.client.getManagedInstanceAnalyticContent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetManagedInstanceContentResponse> getManagedInstanceContent(GetManagedInstanceContentRequest request) {
        return Mono.create(sink -> this.client.getManagedInstanceContent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SummarizeManagedInstanceAnalyticsResponse> summarizeManagedInstanceAnalytics(SummarizeManagedInstanceAnalyticsRequest request) {
        return Mono.create(sink -> this.client.summarizeManagedInstanceAnalytics(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

