/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osmanagementhub;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagementhub.ScheduledJobAsyncClient;
import com.oracle.bmc.osmanagementhub.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagementhub.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagementhub.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ScheduledJobAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ScheduledJobReactorClient {
    ScheduledJobAsyncClient client;

    ScheduledJobReactorClient(ScheduledJobAsyncClient client) {
        this.client = client;
    }

    public Mono<CreateScheduledJobResponse> createScheduledJob(CreateScheduledJobRequest request) {
        return Mono.create(sink -> this.client.createScheduledJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteScheduledJobResponse> deleteScheduledJob(DeleteScheduledJobRequest request) {
        return Mono.create(sink -> this.client.deleteScheduledJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetScheduledJobResponse> getScheduledJob(GetScheduledJobRequest request) {
        return Mono.create(sink -> this.client.getScheduledJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListScheduledJobsResponse> listScheduledJobs(ListScheduledJobsRequest request) {
        return Mono.create(sink -> this.client.listScheduledJobs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RunScheduledJobNowResponse> runScheduledJobNow(RunScheduledJobNowRequest request) {
        return Mono.create(sink -> this.client.runScheduledJobNow(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateScheduledJobResponse> updateScheduledJob(UpdateScheduledJobRequest request) {
        return Mono.create(sink -> this.client.updateScheduledJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

