/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osmanagementhub;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagementhub.SoftwareSourceAsyncClient;
import com.oracle.bmc.osmanagementhub.requests.ChangeAvailabilityOfSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateEntitlementRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.GetErratumRequest;
import com.oracle.bmc.osmanagementhub.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.GetModuleStreamRequest;
import com.oracle.bmc.osmanagementhub.requests.GetPackageGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.ListEntitlementsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListErrataRequest;
import com.oracle.bmc.osmanagementhub.requests.ListModuleStreamProfilesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListModuleStreamsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListPackageGroupsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwarePackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwareSourceVendorsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourceModuleStreamsRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourceModulesRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourcePackageGroupsRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.responses.ChangeAvailabilityOfSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateEntitlementResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.GetErratumResponse;
import com.oracle.bmc.osmanagementhub.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.GetModuleStreamResponse;
import com.oracle.bmc.osmanagementhub.responses.GetPackageGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.ListEntitlementsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListErrataResponse;
import com.oracle.bmc.osmanagementhub.responses.ListModuleStreamProfilesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListModuleStreamsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListPackageGroupsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwarePackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwareSourceVendorsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourceModuleStreamsResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourceModulesResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourcePackageGroupsResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={SoftwareSourceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SoftwareSourceReactorClient {
    SoftwareSourceAsyncClient client;

    SoftwareSourceReactorClient(SoftwareSourceAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeAvailabilityOfSoftwareSourcesResponse> changeAvailabilityOfSoftwareSources(ChangeAvailabilityOfSoftwareSourcesRequest request) {
        return Mono.create(sink -> this.client.changeAvailabilityOfSoftwareSources(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateEntitlementResponse> createEntitlement(CreateEntitlementRequest request) {
        return Mono.create(sink -> this.client.createEntitlement(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSoftwareSourceResponse> createSoftwareSource(CreateSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.createSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSoftwareSourceResponse> deleteSoftwareSource(DeleteSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.deleteSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetErratumResponse> getErratum(GetErratumRequest request) {
        return Mono.create(sink -> this.client.getErratum(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetModuleStreamResponse> getModuleStream(GetModuleStreamRequest request) {
        return Mono.create(sink -> this.client.getModuleStream(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetModuleStreamProfileResponse> getModuleStreamProfile(GetModuleStreamProfileRequest request) {
        return Mono.create(sink -> this.client.getModuleStreamProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetPackageGroupResponse> getPackageGroup(GetPackageGroupRequest request) {
        return Mono.create(sink -> this.client.getPackageGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSoftwarePackageResponse> getSoftwarePackage(GetSoftwarePackageRequest request) {
        return Mono.create(sink -> this.client.getSoftwarePackage(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSoftwareSourceResponse> getSoftwareSource(GetSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.getSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListEntitlementsResponse> listEntitlements(ListEntitlementsRequest request) {
        return Mono.create(sink -> this.client.listEntitlements(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListErrataResponse> listErrata(ListErrataRequest request) {
        return Mono.create(sink -> this.client.listErrata(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListModuleStreamProfilesResponse> listModuleStreamProfiles(ListModuleStreamProfilesRequest request) {
        return Mono.create(sink -> this.client.listModuleStreamProfiles(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListModuleStreamsResponse> listModuleStreams(ListModuleStreamsRequest request) {
        return Mono.create(sink -> this.client.listModuleStreams(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListPackageGroupsResponse> listPackageGroups(ListPackageGroupsRequest request) {
        return Mono.create(sink -> this.client.listPackageGroups(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSoftwarePackagesResponse> listSoftwarePackages(ListSoftwarePackagesRequest request) {
        return Mono.create(sink -> this.client.listSoftwarePackages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSoftwareSourceVendorsResponse> listSoftwareSourceVendors(ListSoftwareSourceVendorsRequest request) {
        return Mono.create(sink -> this.client.listSoftwareSourceVendors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSoftwareSourcesResponse> listSoftwareSources(ListSoftwareSourcesRequest request) {
        return Mono.create(sink -> this.client.listSoftwareSources(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SearchSoftwareSourceModuleStreamsResponse> searchSoftwareSourceModuleStreams(SearchSoftwareSourceModuleStreamsRequest request) {
        return Mono.create(sink -> this.client.searchSoftwareSourceModuleStreams(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SearchSoftwareSourceModulesResponse> searchSoftwareSourceModules(SearchSoftwareSourceModulesRequest request) {
        return Mono.create(sink -> this.client.searchSoftwareSourceModules(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SearchSoftwareSourcePackageGroupsResponse> searchSoftwareSourcePackageGroups(SearchSoftwareSourcePackageGroupsRequest request) {
        return Mono.create(sink -> this.client.searchSoftwareSourcePackageGroups(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateSoftwareSourceResponse> updateSoftwareSource(UpdateSoftwareSourceRequest request) {
        return Mono.create(sink -> this.client.updateSoftwareSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

