/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osmanagementhub;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagementhub.WorkRequestAsyncClient;
import com.oracle.bmc.osmanagementhub.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagementhub.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListWorkRequestsRequest;
import com.oracle.bmc.osmanagementhub.responses.GetWorkRequestResponse;
import com.oracle.bmc.osmanagementhub.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListWorkRequestsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={WorkRequestAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class WorkRequestReactorClient {
    WorkRequestAsyncClient client;

    WorkRequestReactorClient(WorkRequestAsyncClient client) {
        this.client = client;
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

