/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.osmanagementhub;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagementhub.OnboardingAsyncClient;
import com.oracle.bmc.osmanagementhub.requests.CreateProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.GetProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.ListProfilesRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateProfileRequest;
import com.oracle.bmc.osmanagementhub.responses.CreateProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.GetProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.ListProfilesResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateProfileResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OnboardingAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OnboardingRxClient {
    OnboardingAsyncClient client;

    OnboardingRxClient(OnboardingAsyncClient client) {
        this.client = client;
    }

    public Single<CreateProfileResponse> createProfile(CreateProfileRequest request) {
        return Single.create(emitter -> this.client.createProfile(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteProfileResponse> deleteProfile(DeleteProfileRequest request) {
        return Single.create(emitter -> this.client.deleteProfile(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetProfileResponse> getProfile(GetProfileRequest request) {
        return Single.create(emitter -> this.client.getProfile(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListProfilesResponse> listProfiles(ListProfilesRequest request) {
        return Single.create(emitter -> this.client.listProfiles(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateProfileResponse> updateProfile(UpdateProfileRequest request) {
        return Single.create(emitter -> this.client.updateProfile(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

