/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.osubusage;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osubusage.ComputedUsageAsyncClient;
import com.oracle.bmc.osubusage.requests.GetComputedUsageRequest;
import com.oracle.bmc.osubusage.requests.ListComputedUsageAggregatedsRequest;
import com.oracle.bmc.osubusage.requests.ListComputedUsagesRequest;
import com.oracle.bmc.osubusage.responses.GetComputedUsageResponse;
import com.oracle.bmc.osubusage.responses.ListComputedUsageAggregatedsResponse;
import com.oracle.bmc.osubusage.responses.ListComputedUsagesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ComputedUsageAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ComputedUsageReactorClient {
    ComputedUsageAsyncClient client;

    ComputedUsageReactorClient(ComputedUsageAsyncClient client) {
        this.client = client;
    }

    public Mono<GetComputedUsageResponse> getComputedUsage(GetComputedUsageRequest request) {
        return Mono.create(sink -> this.client.getComputedUsage(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListComputedUsageAggregatedsResponse> listComputedUsageAggregateds(ListComputedUsageAggregatedsRequest request) {
        return Mono.create(sink -> this.client.listComputedUsageAggregateds(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListComputedUsagesResponse> listComputedUsages(ListComputedUsagesRequest request) {
        return Mono.create(sink -> this.client.listComputedUsages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

