/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.sch;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.sch.ServiceConnectorAsyncClient;
import com.oracle.bmc.sch.requests.ActivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.ChangeServiceConnectorCompartmentRequest;
import com.oracle.bmc.sch.requests.CreateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeactivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeleteServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetWorkRequestRequest;
import com.oracle.bmc.sch.requests.ListServiceConnectorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.sch.requests.UpdateServiceConnectorRequest;
import com.oracle.bmc.sch.responses.ActivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.ChangeServiceConnectorCompartmentResponse;
import com.oracle.bmc.sch.responses.CreateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeactivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeleteServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetWorkRequestResponse;
import com.oracle.bmc.sch.responses.ListServiceConnectorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.sch.responses.UpdateServiceConnectorResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ServiceConnectorAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ServiceConnectorReactorClient {
    ServiceConnectorAsyncClient client;

    ServiceConnectorReactorClient(ServiceConnectorAsyncClient client) {
        this.client = client;
    }

    public Mono<ActivateServiceConnectorResponse> activateServiceConnector(ActivateServiceConnectorRequest request) {
        return Mono.create(sink -> this.client.activateServiceConnector(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeServiceConnectorCompartmentResponse> changeServiceConnectorCompartment(ChangeServiceConnectorCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeServiceConnectorCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateServiceConnectorResponse> createServiceConnector(CreateServiceConnectorRequest request) {
        return Mono.create(sink -> this.client.createServiceConnector(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeactivateServiceConnectorResponse> deactivateServiceConnector(DeactivateServiceConnectorRequest request) {
        return Mono.create(sink -> this.client.deactivateServiceConnector(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteServiceConnectorResponse> deleteServiceConnector(DeleteServiceConnectorRequest request) {
        return Mono.create(sink -> this.client.deleteServiceConnector(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetServiceConnectorResponse> getServiceConnector(GetServiceConnectorRequest request) {
        return Mono.create(sink -> this.client.getServiceConnector(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListServiceConnectorsResponse> listServiceConnectors(ListServiceConnectorsRequest request) {
        return Mono.create(sink -> this.client.listServiceConnectors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateServiceConnectorResponse> updateServiceConnector(UpdateServiceConnectorRequest request) {
        return Mono.create(sink -> this.client.updateServiceConnector(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

