/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.servicemanagerproxy;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.servicemanagerproxy.ServiceManagerProxyAsyncClient;
import com.oracle.bmc.servicemanagerproxy.requests.GetServiceEnvironmentRequest;
import com.oracle.bmc.servicemanagerproxy.requests.ListServiceEnvironmentsRequest;
import com.oracle.bmc.servicemanagerproxy.responses.GetServiceEnvironmentResponse;
import com.oracle.bmc.servicemanagerproxy.responses.ListServiceEnvironmentsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ServiceManagerProxyAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ServiceManagerProxyReactorClient {
    ServiceManagerProxyAsyncClient client;

    ServiceManagerProxyReactorClient(ServiceManagerProxyAsyncClient client) {
        this.client = client;
    }

    public Mono<GetServiceEnvironmentResponse> getServiceEnvironment(GetServiceEnvironmentRequest request) {
        return Mono.create(sink -> this.client.getServiceEnvironment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListServiceEnvironmentsResponse> listServiceEnvironments(ListServiceEnvironmentsRequest request) {
        return Mono.create(sink -> this.client.listServiceEnvironments(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

