/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.core;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.Readable;
import io.micronaut.core.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;

@ConfigurationProperties(value="oci")
@BootstrapContextCompatible
public class OracleCloudAuthConfigurationProperties {
    public static final String TENANT_ID = "oci.tenant-id";
    @ConfigurationBuilder(prefixes={""}, excludes={"privateKeySupplier"})
    private final SimpleAuthenticationDetailsProvider.SimpleAuthenticationDetailsProviderBuilder builder = SimpleAuthenticationDetailsProvider.builder();

    public SimpleAuthenticationDetailsProvider.SimpleAuthenticationDetailsProviderBuilder getBuilder() {
        return this.builder;
    }

    public void setPrivateKeyFile(Readable privateKeyFile) {
        if (privateKeyFile != null) {
            this.builder.privateKeySupplier(() -> {
                try {
                    return privateKeyFile.asInputStream();
                }
                catch (IOException e) {
                    throw new ConfigurationException("Invalid Oracle Cloud private key specified");
                }
            });
        }
    }

    public void setPrivateKey(String privateKey) {
        if (StringUtils.isNotEmpty((CharSequence)privateKey)) {
            this.builder.privateKeySupplier(() -> new ByteArrayInputStream(privateKey.getBytes()));
        }
    }

    public void setPassphrase(String passphrase) {
        if (StringUtils.isNotEmpty((CharSequence)passphrase)) {
            this.builder.passPhrase(passphrase);
        }
    }

    public void setRegion(String region) {
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            this.builder.region(Region.fromRegionCode((String)region));
        }
    }
}

