/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.core;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.type.Argument;
import java.io.File;

@BootstrapContextCompatible
class OracleCloudConfigCondition
implements Condition {
    OracleCloudConfigCondition() {
    }

    public boolean matches(ConditionContext context) {
        String configPath = context.getProperty("oci.config", Argument.STRING).orElseGet(() -> System.getProperty("user.home") + "/.oci/config");
        if (new File(configPath).exists()) {
            return true;
        }
        context.fail("No Oracle Cloud Configuration found at path: " + configPath);
        return false;
    }
}

