/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.core;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.URLBasedX509CertificateSupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.oraclecloud.core.InstancePrincipalConfiguration;
import io.micronaut.oraclecloud.core.OracleCloudAuthConfigurationProperties;
import io.micronaut.oraclecloud.core.OracleCloudClientConfigurationProperties;
import io.micronaut.oraclecloud.core.OracleCloudConfigCondition;
import io.micronaut.oraclecloud.core.TenancyIdProvider;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Optional;

@Factory
@BootstrapContextCompatible
public class OracleCloudCoreFactory {
    public static final String ORACLE_CLOUD = "oci";
    public static final String METADATA_SERVICE_URL = "http://169.254.169.254/opc/v1/";
    private final String profile;
    private final String configPath;

    protected OracleCloudCoreFactory(@Nullable @Property(name="oci.config.profile") String profile, @Nullable @Property(name="oci.config.path") String configPath) {
        this.profile = profile;
        this.configPath = configPath;
    }

    @Singleton
    @Requirements(value={@Requires(condition=OracleCloudConfigCondition.class), @Requires(missingProperty="oci.tenant-id"), @Requires(missingProperty="oci.config.instance-principal")})
    @Primary
    @BootstrapContextCompatible
    protected ConfigFileAuthenticationDetailsProvider configFileAuthenticationDetailsProvider() throws IOException {
        if (this.getConfigPath().isPresent()) {
            return new ConfigFileAuthenticationDetailsProvider(this.configPath, this.profile);
        }
        return new ConfigFileAuthenticationDetailsProvider(this.profile);
    }

    @Singleton
    @Requirements(value={@Requires(missingProperty="oci.config.instance-principal"), @Requires(property="oci.tenant-id")})
    @Primary
    @BootstrapContextCompatible
    protected SimpleAuthenticationDetailsProvider simpleAuthenticationDetailsProvider(OracleCloudAuthConfigurationProperties config) {
        return config.getBuilder().build();
    }

    @Singleton
    @Requirements(value={@Requires(missingProperty="oci.config.instance-principal"), @Requires(property="OCI_RESOURCE_PRINCIPAL_VERSION")})
    @Primary
    @BootstrapContextCompatible
    protected ResourcePrincipalAuthenticationDetailsProvider resourcePrincipalAuthenticationDetailsProvider() {
        return ResourcePrincipalAuthenticationDetailsProvider.builder().build();
    }

    @Singleton
    @Requires(beans={InstancePrincipalConfiguration.class})
    @Primary
    @BootstrapContextCompatible
    protected InstancePrincipalsAuthenticationDetailsProvider instancePrincipalAuthenticationDetailsProvider(InstancePrincipalConfiguration instancePrincipalConfiguration) {
        return instancePrincipalConfiguration.getBuilder().build();
    }

    @Singleton
    @Primary
    @BootstrapContextCompatible
    protected ClientConfiguration.ClientConfigurationBuilder configurationBuilder(OracleCloudClientConfigurationProperties props) {
        return props.getClientBuilder();
    }

    @Singleton
    @Primary
    @Context
    @BootstrapContextCompatible
    protected TenancyIdProvider tenantIdProvider(@Nullable BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        if (authenticationDetailsProvider == null) {
            throw new DisabledBeanException("Invalid Oracle Cloud Configuration. If you are running locally ensure the CLI is configured by running: oci setup config");
        }
        return () -> {
            if (authenticationDetailsProvider instanceof AuthenticationDetailsProvider) {
                return ((AuthenticationDetailsProvider)authenticationDetailsProvider).getTenantId();
            }
            if (authenticationDetailsProvider instanceof ResourcePrincipalAuthenticationDetailsProvider) {
                return ((ResourcePrincipalAuthenticationDetailsProvider)authenticationDetailsProvider).getStringClaim("res_tenant");
            }
            if (authenticationDetailsProvider instanceof InstancePrincipalsAuthenticationDetailsProvider) {
                String tenantId;
                try {
                    URLBasedX509CertificateSupplier urlBasedX509CertificateSupplier = new URLBasedX509CertificateSupplier(new URL("http://169.254.169.254/opc/v1/identity/cert.pem"), new URL("http://169.254.169.254/opc/v1/identity/key.pem"), (char[])null);
                    tenantId = AuthUtils.getTenantIdFromCertificate((X509Certificate)urlBasedX509CertificateSupplier.getCertificateAndKeyPair().getCertificate());
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Unable to retrieve tenancy ID from metadata.");
                }
                return tenantId;
            }
            return null;
        };
    }

    @Singleton
    @Requires(missingBeans={ClientConfiguration.class})
    @Primary
    @BootstrapContextCompatible
    protected ClientConfiguration clientConfiguration(ClientConfiguration.ClientConfigurationBuilder builder) {
        return builder.build();
    }

    public Optional<String> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    public Optional<String> getConfigPath() {
        return Optional.ofNullable(this.configPath);
    }
}

