/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.core.sdk;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.Objects;

public abstract class AbstractSdkClientFactory<B extends ClientBuilderBase<B, T>, T> {
    private final B builder;

    protected AbstractSdkClientFactory(B builder, ClientConfiguration clientConfiguration, @Nullable ClientConfigurator clientConfigurator, @Nullable RequestSignerFactory requestSignerFactory) {
        this.builder = (ClientBuilderBase)Objects.requireNonNull(builder, "Builder cannot be null");
        builder.configuration(Objects.requireNonNull(clientConfiguration, "Client configuration cannot be null"));
        if (clientConfigurator != null) {
            builder.clientConfigurator(clientConfigurator);
        }
        if (requestSignerFactory != null) {
            builder.requestSignerFactory(requestSignerFactory);
        }
    }

    @NonNull
    protected B getBuilder() {
        return this.builder;
    }

    @NonNull
    protected abstract T build(@NonNull AbstractAuthenticationDetailsProvider var1);
}

