/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http.test;

import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.testing.FnEventBuilder;
import com.fnproject.fn.testing.FnResult;
import com.fnproject.fn.testing.FnTestingRule;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.oraclecloud.function.http.FnMultiValueMap;
import io.micronaut.oraclecloud.function.http.HttpFunction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class FnHttpTest {
    private static final Argument<String> STRING = Argument.of(String.class);

    public static <I> HttpResponse<String> invoke(HttpRequest<I> request) {
        return FnHttpTest.invoke(request, STRING, null);
    }

    public static <I> HttpResponse<String> invoke(HttpRequest<I> request, List<Class<?>> sharedClasses) {
        return FnHttpTest.invoke(request, STRING, sharedClasses);
    }

    public static <I> HttpResponse<String> invoke(HttpMethod method, String uri) {
        return FnHttpTest.invoke(HttpRequest.create((HttpMethod)method, (String)uri), STRING, null);
    }

    public static <I> HttpResponse<String> invoke(HttpMethod method, String uri, List<Class<?>> sharedClasses) {
        return FnHttpTest.invoke(HttpRequest.create((HttpMethod)method, (String)uri), STRING, sharedClasses);
    }

    public static <I, O> HttpResponse<O> invoke(HttpRequest<I> request, Class<O> resultType) {
        return FnHttpTest.invoke(request, Argument.of(resultType), null);
    }

    public static <I, O> HttpResponse<O> invoke(HttpRequest<I> request, Class<O> resultType, List<Class<?>> sharedClasses) {
        return FnHttpTest.invoke(request, Argument.of(resultType), sharedClasses);
    }

    public static <I, O> HttpResponse<O> invoke(HttpRequest<I> request, Argument<O> resultType) {
        return FnHttpTest.invoke(request, resultType, null);
    }

    public static <I, O> HttpResponse<O> invoke(HttpRequest<I> request, Argument<O> resultType, List<Class<?>> sharedClasses) {
        try (ApplicationContext ctx = ApplicationContext.run();){
            MediaTypeCodecRegistry codecRegistry = (MediaTypeCodecRegistry)ctx.getBean(MediaTypeCodecRegistry.class);
            ConversionService conversionService = (ConversionService)ctx.getBean(ConversionService.class);
            Objects.requireNonNull(request, "The request cannot be null");
            Objects.requireNonNull(resultType, "The result type cannot be null");
            FnTestingRule fn = FnTestingRule.createDefault();
            fn.addSharedClassPrefix("org.slf4j.");
            fn.addSharedClassPrefix("com.sun.");
            if (sharedClasses != null) {
                for (Class<?> c : sharedClasses) {
                    fn.addSharedClass(c);
                }
            }
            FnEventBuilder eventBuilder = fn.givenEvent().withHeader("Fn-Http-Request-Url", request.getUri().toString()).withHeader("Fn-Http-Method", request.getMethodName());
            request.getHeaders().forEach((s, values) -> {
                for (String v : values) {
                    eventBuilder.withHeader("Fn-Http-H-" + s, v);
                }
            });
            Object b = request.getBody().orElse(null);
            if (b instanceof byte[]) {
                byte[] ba = (byte[])b;
                eventBuilder.withBody(ba);
            } else if (b instanceof CharSequence) {
                eventBuilder.withBody(b.toString().getBytes(request.getCharacterEncoding()));
            } else if (b != null) {
                MediaTypeCodec codec = request.getContentType().flatMap(arg_0 -> ((MediaTypeCodecRegistry)codecRegistry).findCodec(arg_0)).orElse(null);
                if (codec != null) {
                    eventBuilder.withBody(codec.encode(b));
                } else {
                    eventBuilder.withBody((byte[])conversionService.convertRequired(b, byte[].class));
                }
            }
            eventBuilder.enqueue();
            fn.thenRun(HttpFunction.class, "handleRequest");
            FnResult fnResult = fn.getOnlyResult();
            FnHttpResponse<O> fnHttpResponse = new FnHttpResponse<O>(fnResult, resultType, codecRegistry, conversionService);
            return fnHttpResponse;
        }
    }

    private static final class FnHttpResponse<B>
    implements HttpResponse<B> {
        private final FnResult outputEvent;
        private final FnHeaders fnHeaders;
        private final Argument<B> resultType;
        private final MediaTypeCodecRegistry codecRegistry;
        private final ConversionService conversionService;
        private MutableConvertibleValues<Object> attributes;

        public FnHttpResponse(FnResult outputEvent, Argument<B> resultType, MediaTypeCodecRegistry codecRegistry, ConversionService conversionService) {
            this.outputEvent = outputEvent;
            this.resultType = resultType;
            this.codecRegistry = codecRegistry;
            this.conversionService = conversionService;
            LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
            outputEvent.getHeaders().asMap().forEach((key, strings) -> {
                String httpKey;
                if (key.startsWith("Fn-Http-H-") && (httpKey = key.substring("Fn-Http-H-".length())).length() > 0) {
                    headers.put(httpKey, (List<String>)strings);
                }
            });
            this.fnHeaders = new FnHeaders(headers, conversionService);
        }

        public HttpStatus getStatus() {
            return this.outputEvent.getHeaders().get("Fn-Http-Status").map(s -> HttpStatus.valueOf((int)Integer.parseInt(s))).orElseGet(() -> this.outputEvent.getStatus() == OutputEvent.Status.Success ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR);
        }

        public int code() {
            return this.getStatus().getCode();
        }

        public String reason() {
            return this.getStatus().getReason();
        }

        @NonNull
        public <T> Optional<T> getBody(@NonNull Argument<T> type) {
            return this.conversionService.convert((Object)this.outputEvent.getBodyAsBytes(), type);
        }

        @NonNull
        public HttpHeaders getHeaders() {
            return this.fnHeaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public MutableConvertibleValues<Object> getAttributes() {
            MutableConvertibleValuesMap attributes = this.attributes;
            if (attributes == null) {
                FnHttpResponse fnHttpResponse = this;
                synchronized (fnHttpResponse) {
                    attributes = this.attributes;
                    if (attributes == null) {
                        this.attributes = attributes = new MutableConvertibleValuesMap();
                    }
                }
            }
            return attributes;
        }

        @NonNull
        public Optional<B> getBody() {
            if (CharSequence.class.isAssignableFrom(this.resultType.getType())) {
                return Optional.of(this.outputEvent.getBodyAsString());
            }
            MediaTypeCodec codec = this.getContentType().flatMap(arg_0 -> ((MediaTypeCodecRegistry)this.codecRegistry).findCodec(arg_0)).orElse(null);
            byte[] bodyAsBytes = this.outputEvent.getBodyAsBytes();
            if (codec != null) {
                Object result = codec.decode(this.resultType, bodyAsBytes);
                return Optional.ofNullable(result);
            }
            return this.conversionService.convert((Object)bodyAsBytes, this.resultType);
        }

        @NonNull
        public Optional<MediaType> getContentType() {
            return this.outputEvent.getContentType().map(MediaType::new);
        }

        private static final class FnHeaders
        extends FnMultiValueMap
        implements HttpHeaders {
            public FnHeaders(Map<String, List<String>> map, ConversionService conversionService) {
                super(map, conversionService);
            }
        }
    }
}

