/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http.test;

import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.testing.FnEventBuilder;
import com.fnproject.fn.testing.FnResult;
import com.fnproject.fn.testing.FnTestingRule;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.HttpServerException;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.oraclecloud.function.http.HttpFunction;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

@Singleton
@Secondary
@Internal
final class MockFnHttpServer
implements EmbeddedServer {
    private final ApplicationContext applicationContext;
    private final Map<String, String> testConfig;
    private int port;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Server server;

    public MockFnHttpServer(ApplicationContext applicationContext, HttpServerConfiguration httpServerConfiguration, @Property(name="fn.test.config") @MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.UNDER_SCORE_SEPARATED) Map<String, String> testConfig) {
        this.applicationContext = applicationContext;
        this.testConfig = testConfig;
        Optional port = httpServerConfiguration.getPort();
        if (port.isPresent()) {
            this.port = (Integer)port.get();
            if (this.port == -1) {
                this.port = 0;
            }
        } else {
            this.port = applicationContext.getEnvironment().getActiveNames().contains("test") ? 0 : 8080;
        }
    }

    public EmbeddedServer start() {
        if (this.running.compareAndSet(false, true)) {
            this.server = new Server(this.port);
            this.server.setHandler((Handler)new FnHandler(this.testConfig, this.applicationContext.getEnvironment().getActiveNames()));
            try {
                this.server.start();
                this.port = this.server.getURI().getPort();
            }
            catch (Exception e) {
                throw new ServerStartupException(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public EmbeddedServer stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return "localhost";
    }

    public String getScheme() {
        return "http";
    }

    public URL getURL() {
        String spec = this.getScheme() + "://" + this.getHost() + ":" + this.getPort();
        try {
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new HttpServerException("Invalid server URL " + spec);
        }
    }

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new HttpServerException("Invalid server URL " + this.getURL());
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return (ApplicationConfiguration)this.applicationContext.getBean(ApplicationConfiguration.class);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    private static class FnHandler
    extends AbstractHandler {
        final Map<String, String> testConfig;
        final Set<String> environments;

        FnHandler(Map<String, String> testConfig, Set<String> environments) {
            this.testConfig = testConfig;
            this.environments = environments;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            FnTestingRule fn = FnTestingRule.createDefault();
            this.testConfig.forEach((arg_0, arg_1) -> ((FnTestingRule)fn).setConfig(arg_0, arg_1));
            fn.addSharedClassPrefix("org.slf4j.");
            fn.addSharedClassPrefix("com.sun.");
            String queryString = request.getQueryString();
            Object requestURI = request.getRequestURI();
            if (StringUtils.isNotEmpty((CharSequence)requestURI)) {
                requestURI = (String)requestURI + "?" + queryString;
            }
            FnEventBuilder eventBuilder = fn.givenEvent().withHeader("Fn-Http-Request-Url", (String)requestURI).withHeader("Fn-Http-Method", request.getMethod());
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String s2 = (String)headerNames.nextElement();
                Enumeration headers = request.getHeaders(s2);
                while (headers.hasMoreElements()) {
                    String v = (String)headers.nextElement();
                    eventBuilder.withHeader("Fn-Http-H-" + s2, v);
                }
            }
            HttpMethod httpMethod = HttpMethod.parse((String)request.getMethod());
            if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) {
                try (ServletInputStream requestBody2 = request.getInputStream();){
                    eventBuilder.withBody((InputStream)requestBody2);
                }
                catch (IOException requestBody2) {
                    // empty catch block
                }
            }
            eventBuilder.enqueue();
            String envs = System.getProperty("micronaut.environments");
            System.setProperty("micronaut.environments", String.join((CharSequence)",", this.environments));
            fn.thenRun(HttpFunction.class, "handleRequest");
            if (envs != null) {
                System.setProperty("micronaut.environments", envs);
            }
            FnResult outputEvent = fn.getOnlyResult();
            HttpStatus httpStatus = outputEvent.getHeaders().get("Fn-Http-Status").map(s -> HttpStatus.valueOf((int)Integer.parseInt(s))).orElseGet(() -> outputEvent.getStatus() == OutputEvent.Status.Success ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR);
            byte[] bodyAsBytes = outputEvent.getBodyAsBytes();
            outputEvent.getHeaders().asMap().forEach((key, strings) -> {
                String httpKey;
                if (key.startsWith("Fn-Http-H-") && (httpKey = key.substring("Fn-Http-H-".length())).length() > 0) {
                    for (String string : strings) {
                        response.addHeader(httpKey, string);
                    }
                }
            });
            response.setStatus(httpStatus.getCode());
            response.setContentLength(bodyAsBytes.length);
            if (bodyAsBytes.length > 0) {
                try (ServletOutputStream responseBody = response.getOutputStream();){
                    responseBody.write(bodyAsBytes);
                    responseBody.flush();
                }
            }
        }
    }
}

