/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import com.fnproject.fn.api.RuntimeContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.oraclecloud.function.http.FnBodyBinder;
import io.micronaut.servlet.http.ServletBinderRegistry;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;

@Internal
@Singleton
@Replaces(value=DefaultRequestBinderRegistry.class)
class FnBinderRegistry
extends ServletBinderRegistry {
    private static final Argument<RuntimeContext> RUNTIME_CONTEXT_ARGUMENT = Argument.of(RuntimeContext.class);
    private final RuntimeContext runtimeContext;

    public FnBinderRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService, List<RequestArgumentBinder> binders, RuntimeContext runtimeContext, DefaultBodyAnnotationBinder<?> defaultBodyAnnotationBinder) {
        super(mediaTypeCodecRegistry, conversionService, binders, defaultBodyAnnotationBinder);
        this.runtimeContext = runtimeContext;
        this.byAnnotation.put(Body.class, new FnBodyBinder(conversionService, mediaTypeCodecRegistry, defaultBodyAnnotationBinder));
        this.byType.put(RuntimeContext.class, new FnRuntimeContextBinder());
    }

    private final class FnRuntimeContextBinder
    implements TypedRequestArgumentBinder<RuntimeContext> {
        private final Optional<RuntimeContext> runtimeContext;
        private final ArgumentBinder.BindingResult<RuntimeContext> bindingResult;

        private FnRuntimeContextBinder() {
            this.runtimeContext = Optional.ofNullable(FnBinderRegistry.this.runtimeContext);
            this.bindingResult = () -> this.runtimeContext;
        }

        public Argument<RuntimeContext> argumentType() {
            return RUNTIME_CONTEXT_ARGUMENT;
        }

        public ArgumentBinder.BindingResult<RuntimeContext> bind(ArgumentConversionContext<RuntimeContext> context, HttpRequest<?> source) {
            return this.bindingResult;
        }
    }
}

