/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.oraclecloud.function.http.FnServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Internal
final class FnBodyBinder<T>
implements AnnotatedRequestArgumentBinder<Body, T> {
    private static final Logger LOG = LoggerFactory.getLogger(FnBodyBinder.class);
    private final MediaTypeCodecRegistry mediaTypeCodeRegistry;
    private final DefaultBodyAnnotationBinder<T> defaultBodyBinder;
    private final ConversionService conversionService;

    protected FnBodyBinder(ConversionService conversionService, MediaTypeCodecRegistry mediaTypeCodecRegistry, DefaultBodyAnnotationBinder<T> defaultBodyAnnotationBinder) {
        this.defaultBodyBinder = defaultBodyAnnotationBinder;
        this.mediaTypeCodeRegistry = mediaTypeCodecRegistry;
        this.conversionService = conversionService;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Argument argument = context.getArgument();
        Class type = argument.getType();
        String name = argument.getAnnotationMetadata().stringValue(Body.class).orElse(null);
        if (source instanceof FnServletRequest) {
            FnServletRequest servletHttpRequest = (FnServletRequest)source;
            if (CharSequence.class.isAssignableFrom(type) && name == null) {
                return (ArgumentBinder.BindingResult)servletHttpRequest.getNativeRequest().consumeBody(inputStream -> {
                    try {
                        String content = IOUtils.readText((BufferedReader)new BufferedReader(new InputStreamReader((InputStream)inputStream, source.getCharacterEncoding())));
                        LOG.trace("Read content of length {} from function body", (Object)content.length());
                        return () -> Optional.of(content);
                    }
                    catch (IOException e) {
                        LOG.debug("Error occurred reading function body: {}", (Object)e.getMessage(), (Object)e);
                        return new ArgumentBinder.BindingResult<T>(){

                            public Optional<T> getValue() {
                                return Optional.empty();
                            }

                            public List<ConversionError> getConversionErrors() {
                                return Collections.singletonList(() -> e);
                            }
                        };
                    }
                });
            }
            MediaType mediaType = source.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            MediaTypeCodec codec = this.mediaTypeCodeRegistry.findCodec(mediaType, type).orElse(null);
            if (codec != null) {
                LOG.trace("Decoding function body with codec: {}", (Object)codec.getClass().getSimpleName());
                return (ArgumentBinder.BindingResult)servletHttpRequest.getNativeRequest().consumeBody(inputStream -> {
                    try {
                        if (Publishers.isConvertibleToPublisher((Class)type)) {
                            Argument typeArg = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                            if (Publishers.isSingle((Class)type)) {
                                Object content = codec.decode(typeArg, inputStream);
                                Publisher publisher = Publishers.just((Object)content);
                                LOG.trace("Decoded object from function body: {}", content);
                                Object converted = this.conversionService.convertRequired((Object)publisher, type);
                                return () -> Optional.of(converted);
                            }
                            Argument containerType = Argument.listOf((Class)typeArg.getType());
                            Object content = codec.decode(containerType, inputStream);
                            LOG.trace("Decoded object from function body: {}", content);
                            Flux flowable = Flux.fromIterable((Iterable)((Iterable)content));
                            Object converted = this.conversionService.convertRequired((Object)flowable, type);
                            return () -> Optional.of(converted);
                        }
                        if (type.isArray()) {
                            Class<?> componentType = type.getComponentType();
                            List content = (List)codec.decode(Argument.listOf(componentType), inputStream);
                            LOG.trace("Decoded object from function body: {}", (Object)content);
                            Object[] array = content.toArray((Object[])Array.newInstance(componentType, 0));
                            return () -> Optional.of(array);
                        }
                        Object content = codec.decode(argument, inputStream);
                        LOG.trace("Decoded object from function body: {}", content);
                        return () -> Optional.of(content);
                    }
                    catch (CodecException e) {
                        LOG.trace("Error occurred decoding function body: {}", (Object)e.getMessage(), (Object)e);
                        return new ArgumentBinder.BindingResult<T>(){

                            public Optional<T> getValue() {
                                return Optional.empty();
                            }

                            public List<ConversionError> getConversionErrors() {
                                return Collections.singletonList(() -> e);
                            }
                        };
                    }
                });
            }
        }
        LOG.trace("Not a function request, falling back to default body decoding");
        return this.defaultBodyBinder.bind(context, source);
    }

    public Class<Body> getAnnotationType() {
        return Body.class;
    }
}

