/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.httpgateway.HTTPGatewayContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.simple.cookies.SimpleCookies;
import io.micronaut.oraclecloud.function.http.FnServletResponse;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Internal
final class FnServletRequest<B>
implements ServletHttpRequest<InputEvent, B>,
ServletExchange<InputEvent, OutputEvent> {
    private static final Argument<ConvertibleValues> CONVERTIBLE_VALUES_ARGUMENT = Argument.of(ConvertibleValues.class);
    private final InputEvent inputEvent;
    private final HTTPGatewayContext gatewayContext;
    private final FnServletResponse<Object> response;
    private final ConversionService conversionService;
    private MutableConvertibleValues<Object> attributes;
    private Cookies cookies;
    private final MediaTypeCodecRegistry codecRegistry;
    private final Map<Argument, Optional> consumedBodies = new ConcurrentHashMap<Argument, Optional>();
    private boolean bodyConsumed;

    public FnServletRequest(InputEvent inputEvent, FnServletResponse<Object> response, HTTPGatewayContext gatewayContext, ConversionService conversionService, MediaTypeCodecRegistry codecRegistry) {
        this.inputEvent = inputEvent;
        this.response = response;
        this.gatewayContext = gatewayContext;
        this.conversionService = conversionService;
        this.codecRegistry = codecRegistry;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException("Calling getInputStream() is not supported. If you need an InputSteam define a parameter of type InputEvent and use the consumeBody method");
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException("Calling getReader() is not supported. If you need an InputSteam define a parameter of type InputEvent and use the consumeBody method");
    }

    @NonNull
    public <T> Optional<T> getBody(@NonNull Argument<T> arg) {
        if (arg == null) {
            return Optional.empty();
        }
        if (!this.bodyConsumed) {
            return this.consumedBodies.computeIfAbsent(arg, argument -> (Optional)this.inputEvent.consumeBody(inputStream -> {
                this.bodyConsumed = true;
                Class type = arg.getType();
                MediaType contentType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                MediaTypeCodec codec = this.codecRegistry.findCodec(contentType, type).orElse(null);
                if (codec != null) {
                    if (ConvertibleValues.class == type || Object.class == type) {
                        Map map = (Map)codec.decode(Map.class, inputStream);
                        ConvertibleValues result = ConvertibleValues.of((Map)map);
                        return Optional.of(result);
                    }
                    Object value = codec.decode(arg, inputStream);
                    return Optional.ofNullable(value);
                }
                return Optional.empty();
            }));
        }
        Object body = this.consumedBodies.getOrDefault(CONVERTIBLE_VALUES_ARGUMENT, Optional.empty()).orElse(null);
        if (body != null) {
            return this.consumedBodies.computeIfAbsent(arg, argument -> this.conversionService.convert(body, argument));
        }
        return Optional.empty();
    }

    public InputEvent getNativeRequest() {
        return this.inputEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        Cookies cookies = this.cookies;
        if (cookies == null) {
            FnServletRequest fnServletRequest = this;
            synchronized (fnServletRequest) {
                cookies = this.cookies;
                if (cookies == null) {
                    this.cookies = cookies = new SimpleCookies(this.conversionService);
                }
            }
        }
        return cookies;
    }

    @NonNull
    public HttpParameters getParameters() {
        return new FnHttpParameters();
    }

    @NonNull
    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.gatewayContext.getMethod());
    }

    @NonNull
    public String getMethodName() {
        return this.gatewayContext.getMethod();
    }

    @NonNull
    public URI getUri() {
        return URI.create(this.gatewayContext.getRequestURL());
    }

    @NonNull
    public HttpHeaders getHeaders() {
        return new FnHttpHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            FnServletRequest fnServletRequest = this;
            synchronized (fnServletRequest) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        return this.getBody(CONVERTIBLE_VALUES_ARGUMENT);
    }

    public ServletHttpRequest<InputEvent, ? super Object> getRequest() {
        return this;
    }

    public ServletHttpResponse<OutputEvent, ? super Object> getResponse() {
        return this.response;
    }

    private final class FnHttpParameters
    implements HttpParameters {
        private FnHttpParameters() {
        }

        public List<String> getAll(CharSequence name) {
            if (name != null) {
                return FnServletRequest.this.gatewayContext.getQueryParameters().getValues(name.toString());
            }
            return Collections.emptyList();
        }

        @Nullable
        public String get(CharSequence name) {
            if (name != null) {
                return FnServletRequest.this.gatewayContext.getQueryParameters().get(name.toString()).orElse(null);
            }
            return null;
        }

        public Set<String> names() {
            return FnServletRequest.this.gatewayContext.getQueryParameters().getAll().keySet();
        }

        public Collection<List<String>> values() {
            return FnServletRequest.this.gatewayContext.getQueryParameters().getAll().values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            if (name != null) {
                Optional v = FnServletRequest.this.gatewayContext.getQueryParameters().get(name.toString());
                return v.flatMap(s -> FnServletRequest.this.conversionService.convert(s, conversionContext));
            }
            return Optional.empty();
        }
    }

    private final class FnHttpHeaders
    implements HttpHeaders {
        private FnHttpHeaders() {
        }

        public List<String> getAll(CharSequence name) {
            if (name != null) {
                return FnServletRequest.this.gatewayContext.getHeaders().getAllValues(name.toString());
            }
            return Collections.emptyList();
        }

        @Nullable
        public String get(CharSequence name) {
            if (name != null) {
                return FnServletRequest.this.gatewayContext.getHeaders().get(name.toString()).orElse(null);
            }
            return null;
        }

        public Set<String> names() {
            return new HashSet<String>(FnServletRequest.this.gatewayContext.getHeaders().keys());
        }

        public Collection<List<String>> values() {
            return FnServletRequest.this.gatewayContext.getHeaders().asMap().values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            if (name != null) {
                Optional v = FnServletRequest.this.gatewayContext.getHeaders().get(name.toString());
                return v.flatMap(s -> FnServletRequest.this.conversionService.convert(s, conversionContext));
            }
            return Optional.empty();
        }
    }
}

