/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.http;

import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.RuntimeContext;
import com.fnproject.fn.api.httpgateway.HTTPGatewayContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.oraclecloud.function.OciFunction;
import io.micronaut.oraclecloud.function.http.FnServletRequest;
import io.micronaut.oraclecloud.function.http.FnServletResponse;
import io.micronaut.servlet.http.DefaultServletExchange;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
@ReflectiveAccess
public class HttpFunction
extends OciFunction {
    private ServletHttpHandler<InputEvent, OutputEvent> httpHandler;
    private final ConversionService conversionService;

    public HttpFunction() {
        this.conversionService = new DefaultMutableConversionService();
    }

    @Inject
    protected HttpFunction(ApplicationContext applicationContext) {
        super(applicationContext);
        this.conversionService = applicationContext.getConversionService();
    }

    protected final void setup(RuntimeContext ctx) {
        this.httpHandler = new ServletHttpHandler<InputEvent, OutputEvent>(this.getApplicationContext(), this.conversionService){

            protected ServletExchange<InputEvent, OutputEvent> createExchange(InputEvent request, OutputEvent response) {
                throw new UnsupportedOperationException("Use handleRequest to invoke the function");
            }
        };
        this.setupGateway(ctx);
    }

    protected void setupGateway(@NonNull RuntimeContext ctx) {
    }

    @NonNull
    public final ServletHttpHandler<InputEvent, OutputEvent> getHttpHandler() {
        return this.httpHandler;
    }

    @ReflectiveAccess
    public OutputEvent handleRequest(HTTPGatewayContext gatewayContext, InputEvent inputEvent) {
        FnServletResponse<Object> response = new FnServletResponse<Object>(gatewayContext, this.conversionService);
        FnServletRequest servletRequest = new FnServletRequest(inputEvent, response, gatewayContext, this.conversionService, this.httpHandler.getMediaTypeCodecRegistry());
        DefaultServletExchange exchange = new DefaultServletExchange(servletRequest, response);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(servletRequest)).propagate();){
            this.httpHandler.service((ServletExchange)exchange);
            OutputEvent outputEvent = response.getNativeResponse();
            return outputEvent;
        }
    }
}

