/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.monitoring;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.monitoring.MonitoringClient;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.Objects;

@Singleton
public class MonitoringIngestionClient {
    private final ClientConfiguration clientConfiguration;
    private final ClientConfigurator clientConfigurator;
    private final RequestSignerFactory requestSignerFactory;
    private final RegionProvider regionProvider;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private MonitoringClient delegate;

    public MonitoringIngestionClient(ClientConfiguration clientConfiguration, @Nullable ClientConfigurator clientConfigurator, @Nullable RequestSignerFactory requestSignerFactory, RegionProvider regionProvider, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this.clientConfiguration = clientConfiguration;
        this.clientConfigurator = clientConfigurator;
        this.requestSignerFactory = requestSignerFactory;
        this.regionProvider = regionProvider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MonitoringClient getDelegate() {
        if (this.delegate != null) return this.delegate;
        Class<MonitoringIngestionClient> clazz = MonitoringIngestionClient.class;
        synchronized (MonitoringIngestionClient.class) {
            if (this.delegate != null) return this.delegate;
            String ingestionEndpoint = String.format("https://telemetry-ingestion.%s.oraclecloud.com", this.regionProvider.getRegion().getRegionId());
            MonitoringClient.Builder builder = (MonitoringClient.Builder)MonitoringClient.builder().endpoint(ingestionEndpoint);
            builder.configuration(Objects.requireNonNull(this.clientConfiguration, "Client configuration cannot be null"));
            if (this.clientConfigurator != null) {
                builder.clientConfigurator(this.clientConfigurator);
            }
            if (this.requestSignerFactory != null) {
                builder.requestSignerFactory(this.requestSignerFactory);
            }
            this.delegate = builder.build(this.authenticationDetailsProvider);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.delegate;
        }
    }

    public PostMetricDataResponse postMetricData(PostMetricDataRequest request) {
        return this.getDelegate().postMetricData(request);
    }
}

