/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.monitoring;

import io.micrometer.core.instrument.Clock;
import io.micronaut.configuration.metrics.micrometer.ExportConfigurationProperties;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.core.TenancyIdProvider;
import io.micronaut.oraclecloud.monitoring.MonitoringIngestionClient;
import io.micronaut.oraclecloud.monitoring.micrometer.OracleCloudMeterRegistry;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class OracleCloudMeterRegistryFactory {
    public static final Logger LOG = LoggerFactory.getLogger(OracleCloudMeterRegistryFactory.class);
    public static final String ORACLECLOUD_METRICS_CONFIG = "micronaut.metrics.export.oraclecloud";
    public static final String ORACLECLOUD_METRICS_ENABLED = "micronaut.metrics.export.oraclecloud.enabled";
    private final TenancyIdProvider tenancyIdProvider;
    private final ApplicationConfiguration applicationConfiguration;

    public OracleCloudMeterRegistryFactory(TenancyIdProvider tenancyIdProvider, ApplicationConfiguration applicationConfiguration) {
        this.tenancyIdProvider = tenancyIdProvider;
        this.applicationConfiguration = applicationConfiguration;
    }

    @Singleton
    @Bean(preDestroy="close")
    @Requirements(value={@Requires(property="micronaut.metrics.enabled", notEquals="false", defaultValue="true"), @Requires(property="micronaut.metrics.export.oraclecloud.enabled", notEquals="false", defaultValue="true")})
    OracleCloudMeterRegistry oracleCloudMeterRegistry(ExportConfigurationProperties exportConfigurationProperties, MonitoringIngestionClient monitoringIngestionClient) {
        exportConfigurationProperties.getExport().computeIfAbsent("oraclecloud.applicationName", (Function<? super Object, ?>)((Function<Object, Object>)x -> this.applicationConfiguration.getName().orElse(null)));
        exportConfigurationProperties.getExport().computeIfAbsent("oraclecloud.compartmentId", (Function<? super Object, ?>)((Function<Object, Object>)x -> {
            LOG.info("Default compartmentId set to {}", (Object)this.tenancyIdProvider.getTenancyId());
            return this.tenancyIdProvider.getTenancyId();
        }));
        Properties exportConfig = exportConfigurationProperties.getExport();
        return new OracleCloudMeterRegistry(exportConfig::getProperty, Clock.SYSTEM, monitoringIngestionClient.getDelegate());
    }
}

