/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.monitoring.micrometer;

import com.oracle.bmc.monitoring.model.PostMetricDataDetails;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.util.function.Function;
import java.util.regex.Pattern;

public interface OracleCloudConfig
extends StepRegistryConfig {
    public static final String PREFIX = "oraclecloud";
    public static final String NAMESPACE_REGEX = "^[a-z][a-z0-9_]*[a-z0-9]$";
    public static final Pattern NAMESPACE_PATTERN = Pattern.compile("^[a-z][a-z0-9_]*[a-z0-9]$");

    default public String prefix() {
        return PREFIX;
    }

    default public PostMetricDataDetails.BatchAtomicity batchAtomicity() {
        return (PostMetricDataDetails.BatchAtomicity)PropertyValidator.getEnum((MeterRegistryConfig)this, PostMetricDataDetails.BatchAtomicity.class, (String)"batchAtomicity").orElse(null);
    }

    default public String applicationName() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"applicationName").required().get();
    }

    default public String namespace() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"namespace").required().get();
    }

    default public String compartmentId() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"compartmentId").required().get();
    }

    default public String resourceGroup() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"resourceGroup").orElse(null);
    }

    default public boolean description() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"description").orElse((Object)true);
    }

    default public int batchSize() {
        return (Integer)PropertyValidator.getInteger((MeterRegistryConfig)this, (String)"batchSize").orElse((Object)50);
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), c -> {
            if (!NAMESPACE_PATTERN.matcher(this.namespace()).matches()) {
                return Validated.invalid((String)(this.prefix() + ".namespace"), (Object)this.namespace(), (String)"must match pattern '^[a-z][a-z0-9_]*[a-z0-9]$'", (InvalidReason)InvalidReason.MALFORMED);
            }
            return Validated.valid((String)(this.prefix() + ".namespace"), (Object)this.namespace());
        }});
    }
}

