/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.monitoring.micrometer;

import com.oracle.bmc.monitoring.MonitoringClient;
import com.oracle.bmc.monitoring.model.Datapoint;
import com.oracle.bmc.monitoring.model.MetricDataDetails;
import com.oracle.bmc.monitoring.model.PostMetricDataDetails;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.lang.Nullable;
import io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import io.micronaut.oraclecloud.monitoring.micrometer.MetricDataDetailsPartition;
import io.micronaut.oraclecloud.monitoring.micrometer.OracleCloudConfig;
import io.micronaut.oraclecloud.monitoring.micrometer.OracleCloudMetricsNamingConvention;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleCloudMeterRegistry
extends StepMeterRegistry {
    private final WarnThenDebugLogger warnThenDebugLogger = new WarnThenDebugLogger(OracleCloudMetricsNamingConvention.class);
    private final Logger logger = LoggerFactory.getLogger(OracleCloudMeterRegistry.class);
    private final MonitoringClient monitoringClient;
    private final OracleCloudConfig oracleCloudConfig;

    public OracleCloudMeterRegistry(OracleCloudConfig oracleCloudConfig, Clock clock, MonitoringClient monitoringClient) {
        this(oracleCloudConfig, clock, monitoringClient, (ThreadFactory)new NamedThreadFactory("oraclecloud-metrics-publisher"));
    }

    public OracleCloudMeterRegistry(OracleCloudConfig oracleCloudConfig, Clock clock, MonitoringClient monitoringClient, ThreadFactory threadFactory) {
        super((StepRegistryConfig)oracleCloudConfig, clock);
        this.monitoringClient = monitoringClient;
        this.oracleCloudConfig = oracleCloudConfig;
        this.config().namingConvention((NamingConvention)new OracleCloudMetricsNamingConvention());
        this.config().commonTags(new String[]{"application", oracleCloudConfig.applicationName()});
        this.start(threadFactory);
    }

    protected void publish() {
        for (List<MetricDataDetails> batch : MetricDataDetailsPartition.partition(this.getMetricData(), this.oracleCloudConfig.batchSize())) {
            PostMetricDataDetails.Builder builder = PostMetricDataDetails.builder().metricData(batch);
            if (this.oracleCloudConfig.batchAtomicity() != null) {
                builder.batchAtomicity(this.oracleCloudConfig.batchAtomicity());
            }
            try {
                this.monitoringClient.postMetricData(PostMetricDataRequest.builder().postMetricDataDetails(builder.build()).build());
            }
            catch (Throwable e) {
                this.logger.error("failed to post metrics to oracle cloud infrastructure monitoring: " + e.getMessage(), e);
            }
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    List<MetricDataDetails> getMetricData() {
        return this.getMeters().stream().flatMap(meter -> (Stream)meter.match(this::trackGauge, this::trackCounter, this::trackTimer, this::trackDistributionSummary, this::trackLongTaskTimer, this::trackTimeGauge, this::trackFunctionCounter, this::trackFunctionTimer, this::trackMeter)).collect(Collectors.toList());
    }

    Stream<MetricDataDetails> trackGauge(Gauge gauge) {
        MetricDataDetails metricDataDetails = this.metricDataDetails(gauge.getId(), "value", gauge.value());
        if (metricDataDetails == null) {
            return Stream.empty();
        }
        return Stream.of(metricDataDetails);
    }

    Stream<MetricDataDetails> trackCounter(Counter counter) {
        return Stream.of(this.metricDataDetails(counter.getId(), "count", counter.count()));
    }

    Stream<MetricDataDetails> trackTimer(Timer timer) {
        Stream.Builder<MetricDataDetails> metrics = Stream.builder();
        metrics.add(this.metricDataDetails(timer.getId(), "sum", timer.totalTime(this.getBaseTimeUnit())));
        long count = timer.count();
        metrics.add(this.metricDataDetails(timer.getId(), "count", count));
        if (count > 0L) {
            metrics.add(this.metricDataDetails(timer.getId(), "avg", timer.mean(this.getBaseTimeUnit())));
            metrics.add(this.metricDataDetails(timer.getId(), "max", timer.max(this.getBaseTimeUnit())));
        }
        return metrics.build();
    }

    Stream<MetricDataDetails> trackDistributionSummary(DistributionSummary summary) {
        Stream.Builder<MetricDataDetails> metrics = Stream.builder();
        metrics.add(this.metricDataDetails(summary.getId(), "sum", summary.totalAmount()));
        long count = summary.count();
        metrics.add(this.metricDataDetails(summary.getId(), "count", count));
        if (count > 0L) {
            metrics.add(this.metricDataDetails(summary.getId(), "avg", summary.mean()));
            metrics.add(this.metricDataDetails(summary.getId(), "max", summary.max()));
        }
        return metrics.build();
    }

    Stream<MetricDataDetails> trackLongTaskTimer(LongTaskTimer longTaskTimer) {
        return Stream.of(this.metricDataDetails(longTaskTimer.getId(), "activeTasks", longTaskTimer.activeTasks()), this.metricDataDetails(longTaskTimer.getId(), "duration", longTaskTimer.duration(this.getBaseTimeUnit())));
    }

    Stream<MetricDataDetails> trackTimeGauge(TimeGauge timeGauge) {
        MetricDataDetails metricDatum = this.metricDataDetails(timeGauge.getId(), "value", timeGauge.value(this.getBaseTimeUnit()));
        if (metricDatum == null) {
            return Stream.empty();
        }
        return Stream.of(metricDatum);
    }

    Stream<MetricDataDetails> trackFunctionCounter(FunctionCounter functionCounter) {
        MetricDataDetails metricDataDetails = this.metricDataDetails(functionCounter.getId(), "count", functionCounter.count());
        if (metricDataDetails == null) {
            return Stream.empty();
        }
        return Stream.of(metricDataDetails);
    }

    Stream<MetricDataDetails> trackFunctionTimer(FunctionTimer functionTimer) {
        double sum = functionTimer.totalTime(this.getBaseTimeUnit());
        if (!Double.isFinite(sum)) {
            return Stream.empty();
        }
        Stream.Builder<MetricDataDetails> metrics = Stream.builder();
        double count = functionTimer.count();
        metrics.add(this.metricDataDetails(functionTimer.getId(), "count", count));
        metrics.add(this.metricDataDetails(functionTimer.getId(), "sum", sum));
        if (count > 0.0) {
            metrics.add(this.metricDataDetails(functionTimer.getId(), "avg", functionTimer.mean(this.getBaseTimeUnit())));
        }
        return metrics.build();
    }

    Stream<MetricDataDetails> trackMeter(Meter meter) {
        return StreamSupport.stream(meter.measure().spliterator(), false).map(ms -> this.metricDataDetails(meter.getId().withTag(ms.getStatistic()), null, ms.getValue())).filter(Objects::nonNull);
    }

    MetricDataDetails metricDataDetails(Meter.Id id, @Nullable String suffix, double value) {
        if (Double.isNaN(value)) {
            return null;
        }
        return MetricDataDetails.builder().compartmentId(this.oracleCloudConfig.compartmentId()).name(this.getMetricName(id, suffix)).namespace(this.oracleCloudConfig.namespace()).resourceGroup(this.oracleCloudConfig.resourceGroup()).metadata(this.oracleCloudConfig.description() && id.getDescription() != null ? Collections.singletonMap("description", id.getDescription()) : null).datapoints(Collections.singletonList(Datapoint.builder().value(Double.valueOf(value)).timestamp(new Date()).build())).dimensions(this.toDimensions(id.getConventionTags(this.config().namingConvention()))).build();
    }

    String getMetricName(Meter.Id id, @Nullable String suffix) {
        String name = suffix != null ? id.getName() + "_" + suffix : id.getName();
        return this.config().namingConvention().name(name, id.getType(), id.getBaseUnit());
    }

    Map<String, String> toDimensions(List<Tag> tags) {
        Map<String, String> m = tags.stream().filter(this::isValidTag).collect(Collectors.toMap(Tag::getKey, Tag::getValue));
        return m;
    }

    private boolean isValidTag(Tag tag) {
        if (tag.getKey() == null || tag.getKey().length() == 0 || tag.getValue() == null || tag.getValue().length() == 0) {
            this.warnThenDebugLogger.log("Tag " + tag.getKey() + " not published because tag key or value are empty.");
            return false;
        }
        return true;
    }
}

