/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.monitoring.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import java.util.regex.Pattern;

public class OracleCloudMetricsNamingConvention
implements NamingConvention {
    private static final Pattern NAME_CHARS = Pattern.compile("[^a-zA-Z0-9._\\-$]");
    private static final Pattern TAG_KEY_SPECIAL_CHARS = Pattern.compile("[. ]");
    private static final Pattern PRINTABLE_CHARS = Pattern.compile("[^\\p{Print}]");
    private static final int DIMENSION_NAME_MAX_LENGTH = 256;
    private final WarnThenDebugLogger warnThenDebugLogger = new WarnThenDebugLogger(OracleCloudMetricsNamingConvention.class);

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String sanitized = name;
        if (sanitized.startsWith("oci_")) {
            sanitized = "m_" + sanitized;
            this.warnThenDebugLogger.log("Prefix 'm_' added to the meter name " + name + " as the 'oci_' prefix is reserved");
        }
        if (!Character.isLetter((sanitized = NAME_CHARS.matcher(sanitized).replaceAll("_")).charAt(0))) {
            sanitized = "m_" + sanitized;
            this.warnThenDebugLogger.log("Prefix 'm_' added to the meter " + name + " as valid dimension key starts with alphabetical character");
        }
        return sanitized;
    }

    public String tagKey(String key) {
        String sanitized = PRINTABLE_CHARS.matcher(key).replaceAll("_");
        if ((sanitized = TAG_KEY_SPECIAL_CHARS.matcher(sanitized).replaceAll("_")).length() > 256) {
            sanitized = sanitized.substring(0, 256);
            this.warnThenDebugLogger.log("Trimmed tag key " + key + " to maximum allowed length " + 256 + " chars");
        }
        return sanitized;
    }

    public String tagValue(String value) {
        String sanitized = PRINTABLE_CHARS.matcher(value).replaceAll("_");
        if (sanitized.length() > 256) {
            sanitized = sanitized.substring(0, 256);
            this.warnThenDebugLogger.log("Trimmed tag value " + value + " to maximum allowed length " + 256 + " chars");
        }
        return sanitized;
    }
}

