/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.svm.core.annotate.AutomaticFeature;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.graal.AutomaticFeatureUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
@Internal
final class SdkAutomaticFeature
implements Feature {
    SdkAutomaticFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Arrays.asList("org.glassfish.jersey.internal.LocalizationMessages", "org.glassfish.jersey.message.internal.MediaTypeProvider", "org.glassfish.jersey.message.internal.CacheControlProvider", "org.glassfish.jersey.message.internal.LinkProvider").forEach(n -> AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String)n));
        HashSet reflectiveAccess = new HashSet();
        SdkAutomaticFeature.populateReflectionData(reflectiveAccess, ResponseHelper.ErrorCodeAndMessage.class);
        String[] classes = SdkAutomaticFeature.resolveOracleCloudClientNamesFromManifest().toArray(new String[0]);
        for (String aClass : classes) {
            Class c = access.findClassByName(aClass);
            if (c == null) continue;
            Set allInterfaces = ReflectionUtils.getAllInterfaces((Class)c);
            for (Class i : allInterfaces) {
                if (i.getName().endsWith("Async")) continue;
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, i);
            }
        }
        for (Class clazz : reflectiveAccess) {
            boolean hasNoArgsConstructor = !clazz.isEnum() && !clazz.isInterface() && this.hasNoArgsConstructor(clazz.getDeclaredConstructors());
            RuntimeReflection.register((Class[])new Class[]{clazz});
            if (hasNoArgsConstructor) {
                RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
            }
            for (Method method : clazz.getDeclaredMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{method});
            }
            if (clazz.isInterface()) continue;
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                RuntimeReflection.register((Field[])new Field[]{accessibleObject});
            }
        }
    }

    public static List<String> resolveOracleCloudClientNamesFromManifest() {
        try {
            ArrayList<String> results = new ArrayList<String>();
            Enumeration<URL> manifests = SdkAutomaticFeature.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL url = manifests.nextElement();
                if (!url.getPath().contains("oci-java")) continue;
                InputStream is = url.openStream();
                try {
                    Manifest manifest = new Manifest(is);
                    Map<String, Attributes> entries = manifest.getEntries();
                    entries.keySet().stream().filter(key -> key.endsWith("Client.class") && !SdkAutomaticFeature.isSdkInternal(key)).forEach(fileName -> results.add(fileName.replace('/', '.').substring(0, fileName.length() - 6)));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            return results;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private static boolean isSdkInternal(String key) {
        return Stream.of("/internal/", "/auth/", "/streaming/", "/keymanagement/").anyMatch(key::contains);
    }

    private boolean hasNoArgsConstructor(Constructor<?>[] declaredConstructors) {
        boolean hasNoArgsConstructor = false;
        for (Constructor<?> declaredConstructor : declaredConstructors) {
            if (declaredConstructor.getParameterCount() != 0) continue;
            hasNoArgsConstructor = true;
            break;
        }
        return hasNoArgsConstructor;
    }

    static void populateReflectionData(Set<Class<?>> reflectiveAccess, Class<?> type) {
        Object[] types;
        JsonSubTypes subTypes;
        Class di;
        JsonTypeInfo ti;
        Class builder;
        JsonDeserialize deser = type.getAnnotation(JsonDeserialize.class);
        if (deser != null && (builder = deser.builder()) != Void.class && SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, builder)) {
            reflectiveAccess.add(builder);
            SdkAutomaticFeature.populateReflectionData(reflectiveAccess, builder);
        }
        if ((ti = type.getAnnotation(JsonTypeInfo.class)) != null && (di = ti.defaultImpl()) != type && SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, di)) {
            reflectiveAccess.add(di);
            SdkAutomaticFeature.populateReflectionData(reflectiveAccess, di);
        }
        if ((subTypes = type.getAnnotation(JsonSubTypes.class)) != null && ArrayUtils.isNotEmpty((Object[])(types = subTypes.value()))) {
            for (Object t : types) {
                Class v = t.value();
                if (!SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, v)) continue;
                reflectiveAccess.add(v);
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, v);
            }
        }
        Method[] methods = type.getDeclaredMethods();
        for (Method m : methods) {
            Class<?>[] parameterTypes;
            Class<?> rt = m.getReturnType();
            if (Collection.class.isAssignableFrom(rt)) {
                Type arg;
                Type[] args;
                Type grt = m.getGenericReturnType();
                if (grt instanceof ParameterizedType && (args = ((ParameterizedType)grt).getActualTypeArguments()) != null && args.length == 1 && (arg = args[0]) instanceof Class && SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, arg)) {
                    Class t = (Class)arg;
                    reflectiveAccess.add(t);
                    SdkAutomaticFeature.populateReflectionData(reflectiveAccess, t);
                }
            } else if (SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, rt)) {
                reflectiveAccess.add(rt);
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, rt);
            }
            for (Class<?> pt : parameterTypes = m.getParameterTypes()) {
                if (!SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, pt)) continue;
                reflectiveAccess.add(pt);
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, pt);
            }
        }
    }

    static boolean includeInReflectiveData(Set<Class<?>> reflectiveAccess, Type rt) {
        return rt.getTypeName().startsWith("com.oracle.bmc") && !reflectiveAccess.contains(rt);
    }
}

