/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.problem;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.problem.HttpStatusType;
import io.micronaut.problem.conf.ProblemConfiguration;
import io.micronaut.problem.violations.ConstraintViolationThrowableProblem;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Map;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@Singleton
public class ProblemErrorResponseProcessor
implements ErrorResponseProcessor<Problem> {
    public static final String APPLICATION_PROBLEM_JSON = "application/problem+json";
    private final boolean stackTraceConfig;

    @Deprecated
    public ProblemErrorResponseProcessor() {
        this(() -> false);
    }

    @Inject
    public ProblemErrorResponseProcessor(ProblemConfiguration config) {
        this.stackTraceConfig = config.isStackTrace();
    }

    @NonNull
    public MutableHttpResponse<Problem> processResponse(@NonNull ErrorContext errorContext, @NonNull MutableHttpResponse<?> baseResponse) {
        if (errorContext.getRequest().getMethod() == HttpMethod.HEAD) {
            return baseResponse;
        }
        ThrowableProblem throwableProblem = errorContext.getRootCause().filter(t -> t instanceof ThrowableProblem).map(t -> (ThrowableProblem)t).orElseGet(() -> this.defaultProblem(errorContext, baseResponse.getStatus()));
        Object body = this.stackTraceConfig ? throwableProblem : (throwableProblem instanceof ConstraintViolationThrowableProblem ? throwableProblem : new ThrowableProblemWithoutStacktrace(throwableProblem));
        return baseResponse.contentType((CharSequence)APPLICATION_PROBLEM_JSON).body(body);
    }

    @NonNull
    protected ThrowableProblem defaultProblem(@NonNull ErrorContext errorContext, @NonNull HttpStatus httpStatus) {
        ProblemBuilder problemBuilder = Problem.builder().withStatus((StatusType)new HttpStatusType(httpStatus));
        if (!errorContext.getErrors().isEmpty()) {
            Error error = (Error)errorContext.getErrors().get(0);
            error.getTitle().ifPresent(arg_0 -> ((ProblemBuilder)problemBuilder).withTitle(arg_0));
            if (this.includeErrorMessage(errorContext)) {
                problemBuilder.withDetail(error.getMessage());
            }
            error.getPath().ifPresent(path -> problemBuilder.with("path", path));
        }
        return problemBuilder.build();
    }

    protected boolean includeErrorMessage(@NonNull ErrorContext errorContext) {
        return errorContext.getRootCause().map(UnsatisfiedRouteException.class::isInstance).orElse(false);
    }

    @Introspected
    static final class ThrowableProblemWithoutStacktrace
    implements Problem {
        @JsonUnwrapped
        @JsonIgnoreProperties(value={"stackTrace", "localizedMessage", "message", "type", "title", "status", "detail", "instance", "parameters"})
        final ThrowableProblem problem;

        ThrowableProblemWithoutStacktrace(ThrowableProblem problem) {
            this.problem = problem;
        }

        public URI getType() {
            return this.problem.getType();
        }

        public String getTitle() {
            return this.problem.getTitle();
        }

        public StatusType getStatus() {
            return this.problem.getStatus();
        }

        public String getDetail() {
            return this.problem.getDetail();
        }

        public URI getInstance() {
            return this.problem.getInstance();
        }

        public Map<String, Object> getParameters() {
            return this.problem.getParameters();
        }
    }
}

