/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.problem.violations;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.problem.violations.Violation;
import io.micronaut.serde.annotation.Serdeable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@JsonIgnoreProperties(value={"stackTrace", "localizedMessage", "message"})
@Serdeable
public class ConstraintViolationThrowableProblem
extends ThrowableProblem {
    public static final String TYPE_VALUE = "https://zalando.github.io/problem/constraint-violation";
    public static final URI TYPE = URI.create("https://zalando.github.io/problem/constraint-violation");
    @NonNull
    private final URI type;
    @NonNull
    private final StatusType status;
    @NonNull
    private final List<Violation> violations;

    public ConstraintViolationThrowableProblem(@NonNull StatusType status, @Nullable List<Violation> violations) {
        this(TYPE, status, violations != null ? new ArrayList<Violation>(violations) : new ArrayList());
    }

    public ConstraintViolationThrowableProblem(@NonNull URI type, @NonNull StatusType status, @Nullable List<Violation> violations) {
        this.type = type;
        this.status = status;
        this.violations = violations != null ? Collections.unmodifiableList(violations) : Collections.emptyList();
    }

    @NonNull
    public URI getType() {
        return this.type;
    }

    @NonNull
    public String getTitle() {
        return "Constraint Violation";
    }

    @NonNull
    public StatusType getStatus() {
        return this.status;
    }

    @NonNull
    public List<Violation> getViolations() {
        return this.violations;
    }
}

