/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.problem.violations;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.problem.HttpStatusType;
import io.micronaut.problem.violations.ConstraintViolationThrowableProblem;
import io.micronaut.problem.violations.Violation;
import io.micronaut.validation.exceptions.ConstraintExceptionHandler;
import jakarta.inject.Singleton;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

@Produces
@Singleton
@Requires(classes={ConstraintViolationException.class, ExceptionHandler.class})
@Replaces(value=ConstraintExceptionHandler.class)
public class ProblemConstraintViolationExceptionHandler
implements ExceptionHandler<ConstraintViolationException, HttpResponse<?>> {
    private final ErrorResponseProcessor<?> responseProcessor;

    public ProblemConstraintViolationExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    public HttpResponse<?> handle(HttpRequest request, ConstraintViolationException exception) {
        HttpStatus httpStatus = HttpStatus.BAD_REQUEST;
        return this.responseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).cause((Throwable)((Object)new ConstraintViolationThrowableProblem(new HttpStatusType(httpStatus), exception.getConstraintViolations().stream().map(this::createViolation).collect(Collectors.toList())))).errorMessage(exception.getMessage()).build(), HttpResponse.status((HttpStatus)httpStatus));
    }

    @NonNull
    protected Violation createViolation(@NonNull ConstraintViolation<?> constraintViolation) {
        return new Violation(constraintViolation.getPropertyPath().toString(), constraintViolation.getMessage());
    }
}

