/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.problem;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.problem.HttpStatusType;
import io.micronaut.problem.conf.ProblemConfiguration;
import io.micronaut.problem.violations.ConstraintViolationThrowableProblem;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@Singleton
public class ProblemErrorResponseProcessor
implements ErrorResponseProcessor<Problem> {
    public static final String APPLICATION_PROBLEM_JSON = "application/problem+json";
    private final boolean stackTraceConfig;

    public ProblemErrorResponseProcessor(ProblemConfiguration config) {
        this.stackTraceConfig = config.isStackTrace();
    }

    @NonNull
    public MutableHttpResponse<Problem> processResponse(@NonNull ErrorContext errorContext, @NonNull MutableHttpResponse<?> baseResponse) {
        Object body;
        if (errorContext.getRequest().getMethod() == HttpMethod.HEAD) {
            return baseResponse;
        }
        ThrowableProblem throwableProblem = errorContext.getRootCause().filter(t -> t instanceof ThrowableProblem).map(t -> (ThrowableProblem)t).orElseGet(() -> this.defaultProblem(errorContext, baseResponse.getStatus()));
        if (this.stackTraceConfig) {
            body = throwableProblem;
        } else if (throwableProblem instanceof ConstraintViolationThrowableProblem) {
            body = throwableProblem;
        } else {
            try {
                body = new IntrospectedThrowableProblemWithoutStacktrace(throwableProblem);
            }
            catch (IntrospectionException e) {
                body = new ThrowableProblemWithoutStacktrace(throwableProblem);
            }
        }
        return baseResponse.contentType((CharSequence)APPLICATION_PROBLEM_JSON).body(body);
    }

    @NonNull
    protected ThrowableProblem defaultProblem(@NonNull ErrorContext errorContext, @NonNull HttpStatus httpStatus) {
        ProblemBuilder problemBuilder = Problem.builder().withStatus((StatusType)new HttpStatusType(httpStatus));
        if (!errorContext.getErrors().isEmpty()) {
            Error error = (Error)errorContext.getErrors().get(0);
            error.getTitle().ifPresent(arg_0 -> ((ProblemBuilder)problemBuilder).withTitle(arg_0));
            if (this.includeErrorMessage(errorContext)) {
                problemBuilder.withDetail(error.getMessage());
            }
            error.getPath().ifPresent(path -> problemBuilder.with("path", path));
        }
        return problemBuilder.build();
    }

    protected boolean includeErrorMessage(@NonNull ErrorContext errorContext) {
        return errorContext.getRootCause().map(UnsatisfiedRouteException.class::isInstance).orElse(false);
    }

    @Serdeable
    static final class IntrospectedThrowableProblemWithoutStacktrace
    implements Problem {
        private static final List<String> SKIP_FIELDS = Arrays.asList("stackTrace", "cause", "suppressed", "localizedMessage", "message", "type", "title", "status", "detail", "instance", "parameters");
        private final ThrowableProblem throwableProblem;
        private final Map<String, Object> properties;

        IntrospectedThrowableProblemWithoutStacktrace(ThrowableProblem problem) {
            this.throwableProblem = problem;
            this.properties = IntrospectedThrowableProblemWithoutStacktrace.filterProperties(problem);
        }

        private static Map<String, Object> filterProperties(ThrowableProblem problem) {
            BeanWrapper wrapper = BeanWrapper.getWrapper((Object)problem);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (String propertyName : wrapper.getPropertyNames()) {
                if (SKIP_FIELDS.contains(propertyName)) continue;
                properties.put(propertyName, wrapper.getProperty(propertyName, Object.class).orElse(null));
            }
            return properties;
        }

        @JsonAnyGetter
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public URI getType() {
            return this.throwableProblem.getType();
        }

        public String getTitle() {
            return this.throwableProblem.getTitle();
        }

        public StatusType getStatus() {
            return this.throwableProblem.getStatus();
        }

        public String getDetail() {
            return this.throwableProblem.getDetail();
        }

        public URI getInstance() {
            return this.throwableProblem.getInstance();
        }

        public Map<String, Object> getParameters() {
            return this.throwableProblem.getParameters();
        }
    }

    @Serdeable
    static final class ThrowableProblemWithoutStacktrace
    implements Problem {
        final ThrowableProblem problem;

        ThrowableProblemWithoutStacktrace(ThrowableProblem problem) {
            this.problem = problem;
        }

        @JsonUnwrapped
        @JsonIgnoreProperties(value={"stackTrace", "localizedMessage", "message", "type", "title", "status", "detail", "instance", "parameters"})
        public ThrowableProblem getProblem() {
            return this.problem;
        }

        public URI getType() {
            return this.problem.getType();
        }

        public String getTitle() {
            return this.problem.getTitle();
        }

        public StatusType getStatus() {
            return this.problem.getStatus();
        }

        public String getDetail() {
            return this.problem.getDetail();
        }

        public URI getInstance() {
            return this.problem.getInstance();
        }

        public Map<String, Object> getParameters() {
            return this.problem.getParameters();
        }
    }
}

