/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.problem;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.JsonErrorResponseBodyProvider;
import io.micronaut.problem.HttpStatusType;
import io.micronaut.problem.conf.ProblemConfiguration;
import io.micronaut.problem.violations.ConstraintViolationThrowableProblem;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Map;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@Singleton
public class ProblemJsonErrorResponseBodyProvider
implements JsonErrorResponseBodyProvider<Problem> {
    public static final String APPLICATION_PROBLEM_JSON = "application/problem+json";
    private final boolean stackTraceConfig;

    public ProblemJsonErrorResponseBodyProvider(ProblemConfiguration config) {
        this.stackTraceConfig = config.isStackTrace();
    }

    public String contentType() {
        return APPLICATION_PROBLEM_JSON;
    }

    @NonNull
    public Problem body(@NonNull ErrorContext errorContext, @NonNull HttpResponse<?> response) {
        ThrowableProblem throwableProblem = errorContext.getRootCause().filter(ThrowableProblem.class::isInstance).map(t -> (ThrowableProblem)t).orElseGet(() -> this.defaultProblem(errorContext, response.getStatus()));
        if (this.stackTraceConfig) {
            return throwableProblem;
        }
        if (throwableProblem instanceof ConstraintViolationThrowableProblem) {
            return throwableProblem;
        }
        return new ThrowableProblemWithoutStacktrace(throwableProblem);
    }

    @NonNull
    protected ThrowableProblem defaultProblem(@NonNull ErrorContext errorContext, @NonNull HttpStatus httpStatus) {
        ProblemBuilder problemBuilder = Problem.builder().withStatus((StatusType)new HttpStatusType(httpStatus));
        if (!errorContext.getErrors().isEmpty()) {
            Error error = (Error)errorContext.getErrors().get(0);
            error.getTitle().ifPresent(arg_0 -> ((ProblemBuilder)problemBuilder).withTitle(arg_0));
            if (this.includeErrorMessage(errorContext)) {
                problemBuilder.withDetail(error.getMessage());
            }
            error.getPath().ifPresent(path -> problemBuilder.with("path", path));
        }
        return problemBuilder.build();
    }

    protected boolean includeErrorMessage(@NonNull ErrorContext errorContext) {
        return errorContext.getRootCause().map(UnsatisfiedRouteException.class::isInstance).orElse(false);
    }

    @Serdeable
    static final class ThrowableProblemWithoutStacktrace
    implements Problem {
        final ThrowableProblem problem;

        ThrowableProblemWithoutStacktrace(ThrowableProblem problem) {
            this.problem = problem;
        }

        @JsonUnwrapped
        @JsonIgnoreProperties(value={"stackTrace", "localizedMessage", "message", "type", "title", "status", "detail", "instance", "parameters"})
        public ThrowableProblem getProblem() {
            return this.problem;
        }

        public URI getType() {
            return this.problem.getType();
        }

        public String getTitle() {
            return this.problem.getTitle();
        }

        public StatusType getStatus() {
            return this.problem.getStatus();
        }

        public String getDetail() {
            return this.problem.getDetail();
        }

        public URI getInstance() {
            return this.problem.getInstance();
        }

        public Map<String, Object> getParameters() {
            return this.problem.getParameters();
        }
    }
}

