/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.messaging.exceptions.MessagingClientException;
import io.micronaut.pulsar.config.PulsarClientConfiguration;
import io.netty.channel.EventLoopGroup;
import jakarta.inject.Singleton;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.ClientBuilderImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;

@Factory
@Requires(beans={PulsarClientConfiguration.class})
public final class PulsarClientFactory {
    @Singleton
    public PulsarClient pulsarClient(PulsarClientConfiguration pulsarClientConfiguration, EventLoopGroup eventLoopGroup) throws MessagingClientException {
        ClientBuilderImpl clientBuilder = (ClientBuilderImpl)new ClientBuilderImpl().authentication(pulsarClientConfiguration.getAuthentication());
        if (pulsarClientConfiguration.getServiceUrlProvider().isPresent()) {
            clientBuilder.serviceUrlProvider(pulsarClientConfiguration.getServiceUrlProvider().get());
        } else {
            clientBuilder.serviceUrl(pulsarClientConfiguration.getServiceUrl());
        }
        pulsarClientConfiguration.getIoThreads().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).ioThreads(arg_0));
        pulsarClientConfiguration.getListenerThreads().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).listenerThreads(arg_0));
        pulsarClientConfiguration.getSslProvider().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).sslProvider(arg_0));
        pulsarClientConfiguration.getTlsTrustStorePath().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).tlsTrustStorePath(arg_0));
        pulsarClientConfiguration.getTlsTrustStorePassword().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).tlsTrustStorePassword(arg_0));
        pulsarClientConfiguration.getTlsCertFilePath().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).tlsTrustCertsFilePath(arg_0));
        pulsarClientConfiguration.getTlsAllowInsecureConnection().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).allowTlsInsecureConnection(arg_0));
        pulsarClientConfiguration.getTlsVerifyHostname().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).enableTlsHostnameVerification(arg_0));
        pulsarClientConfiguration.getTlsCiphers().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).tlsCiphers(arg_0));
        pulsarClientConfiguration.getTlsProtocols().ifPresent(arg_0 -> ((ClientBuilderImpl)clientBuilder).tlsProtocols(arg_0));
        try {
            ClientConfigurationData data = clientBuilder.getClientConfigurationData();
            return new PulsarClientImpl(data, eventLoopGroup);
        }
        catch (Exception ex) {
            throw new MessagingClientException("Failed to initialize Pulsar Client", (Throwable)ex);
        }
    }
}

