/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.type.Argument;
import io.micronaut.messaging.exceptions.MessagingClientException;
import io.micronaut.pulsar.annotation.PulsarProducer;
import io.micronaut.pulsar.processor.DefaultSchemaHandler;
import io.micronaut.pulsar.processor.PulsarArgumentHandler;
import io.micronaut.pulsar.processor.TopicResolver;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ProducerBuilderImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;

@Factory
public class PulsarProducerFactory {
    private final TopicResolver topicResolver;

    public PulsarProducerFactory(TopicResolver topicResolver) {
        this.topicResolver = topicResolver;
    }

    @Prototype
    public <T> Producer<T> createProducer(@Parameter PulsarClient pulsarClient, @Parameter AnnotationValue<PulsarProducer> annotationValue, @Parameter Argument<?>[] methodArguments, @Parameter DefaultSchemaHandler simpleSchemaResolver, @Parameter String annotatedMethodName) throws MessagingClientException {
        PulsarArgumentHandler argsHandler = new PulsarArgumentHandler(methodArguments, annotatedMethodName);
        Schema<?> schema = simpleSchemaResolver.decideSchema(argsHandler.getBodyArgument(), argsHandler.getKeyArgument(), annotationValue, annotatedMethodName);
        String producerName = annotationValue.stringValue("producerName").orElse(annotatedMethodName);
        TopicResolver.TopicResolved topicResolved = TopicResolver.extractTopic(annotationValue, producerName);
        ProducerBuilder producerBuilder = new ProducerBuilderImpl((PulsarClientImpl)pulsarClient, schema).producerName(producerName).topic(this.topicResolver.resolve(topicResolved.getTopic()));
        annotationValue.booleanValue("multiSchema").ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).enableMultiSchema(arg_0));
        annotationValue.booleanValue("autoUpdatePartition").ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).autoUpdatePartitions(arg_0));
        annotationValue.booleanValue("blockQueue").ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).blockIfQueueFull(arg_0));
        annotationValue.booleanValue("batching").ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).blockIfQueueFull(arg_0));
        annotationValue.booleanValue("chunking").ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).enableChunking(arg_0));
        annotationValue.stringValue("encryptionKey").ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).addEncryptionKey(arg_0));
        annotationValue.longValue("initialSequenceId").ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).initialSequenceId(arg_0));
        annotationValue.enumValue("hashingScheme", HashingScheme.class).ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).hashingScheme(arg_0));
        annotationValue.enumValue("compressionType", CompressionType.class).ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).compressionType(arg_0));
        annotationValue.enumValue("messageRoutingMode", MessageRoutingMode.class).ifPresent(arg_0 -> ((ProducerBuilder)producerBuilder).messageRoutingMode(arg_0));
        try {
            return producerBuilder.create();
        }
        catch (Exception ex) {
            String message = "Failed to initialize Pulsar producer %s on topic %s".formatted(producerName, topicResolved.getTopic());
            throw new MessagingClientException(message, (Throwable)ex);
        }
    }
}

