/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.pulsar;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.ArgumentInjectionPoint;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.pulsar.PulsarReaderRegistry;
import io.micronaut.pulsar.annotation.PulsarReader;
import io.micronaut.pulsar.processor.DefaultSchemaHandler;
import io.micronaut.pulsar.processor.TopicResolver;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class PulsarReaderFactory
implements AutoCloseable,
PulsarReaderRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarReaderFactory.class);
    private final Map<String, Reader<?>> readers = new ConcurrentHashMap();
    private final PulsarClient pulsarClient;
    private final DefaultSchemaHandler simpleSchemaResolver;
    private final TopicResolver topicResolver;

    public PulsarReaderFactory(PulsarClient pulsarClient, DefaultSchemaHandler simpleSchemaResolver, TopicResolver topicResolver) {
        this.pulsarClient = pulsarClient;
        this.simpleSchemaResolver = simpleSchemaResolver;
        this.topicResolver = topicResolver;
    }

    @Prototype
    public Reader<?> getReaderByInjectionPoint(BeanResolutionContext context, @Nullable @Parameter AnnotationValue<PulsarReader> annotationValue, @Nullable @Parameter Argument<?> returnType, @Nullable @Parameter MethodInvocationContext<?, ?> methodInvocationContext) throws PulsarClientException {
        if (context.getPath().currentSegment().isEmpty()) {
            return this.getReaderForAnnotation(Objects.requireNonNull(annotationValue), Objects.requireNonNull(returnType), Objects.requireNonNull(methodInvocationContext));
        }
        return this.getReaderByInjectionPoint(context);
    }

    private Reader<?> getReaderByInjectionPoint(BeanResolutionContext context) throws PulsarClientException {
        Object target;
        String declaredName;
        Argument readerArgument;
        InjectionPoint injectionPoint = ((BeanResolutionContext.Segment)context.getPath().currentSegment().orElseThrow(() -> new IllegalStateException("Could not resolve current injection context while creating a reader"))).getInjectionPoint();
        AnnotationValue annotation = injectionPoint.getAnnotation(PulsarReader.class);
        if (null == annotation) {
            throw new IllegalStateException("Failed to get value for bean annotated with PulsarReader");
        }
        String topicValue = (String)annotation.getRequiredValue(String.class);
        if (injectionPoint instanceof ArgumentInjectionPoint) {
            ArgumentInjectionPoint argumentInjection = (ArgumentInjectionPoint)injectionPoint;
            readerArgument = argumentInjection.getArgument().getFirstTypeVariable().orElse(Argument.of(byte[].class));
            declaredName = argumentInjection.getArgument().getName();
            target = argumentInjection.getDeclaringBean().getName() + " " + declaredName;
            if (argumentInjection.getOuterInjectionPoint() instanceof ConstructorInjectionPoint && TopicResolver.isDynamicTenantInTopic(topicValue)) {
                throw new ConfigurationException(String.format("Cannot use dynamic tenant in topics for constructor injected Readers in %s", target));
            }
        } else if (injectionPoint instanceof FieldInjectionPoint) {
            FieldInjectionPoint fieldInjection = (FieldInjectionPoint)injectionPoint;
            readerArgument = fieldInjection.asArgument().getFirstTypeVariable().orElse(Argument.of(byte[].class));
            declaredName = fieldInjection.getName();
            target = fieldInjection.getDeclaringBean().getName() + "::" + declaredName;
            if (TopicResolver.isDynamicTenantInTopic(topicValue)) {
                throw new ConfigurationException(String.format("Cannot use dynamic tenant in topics for field injected Readers in %s", target));
            }
        } else {
            readerArgument = Argument.of(byte[].class);
            declaredName = injectionPoint.getDeclaringBean().getName();
            target = declaredName;
            if (TopicResolver.isDynamicTenantInTopic(topicValue)) {
                throw new ConfigurationException(String.format("Cannot use dynamic tenant in topics for field injected Readers in %s", target));
            }
        }
        return this.getOrCreateReader((AnnotationValue<PulsarReader>)annotation, readerArgument, declaredName, (String)target);
    }

    private Reader<?> getReaderForAnnotation(AnnotationValue<PulsarReader> annotationValue, Argument<?> returnType, MethodInvocationContext<?, ?> methodInvocationContext) throws PulsarClientException {
        String target = methodInvocationContext.getExecutableMethod().getDescription(false);
        String declaredName = methodInvocationContext.getExecutableMethod().getName();
        return this.getOrCreateReader(annotationValue, returnType, declaredName, target);
    }

    private Reader<?> getOrCreateReader(AnnotationValue<PulsarReader> annotation, Argument<?> readerArgument, String declaredName, String target) throws PulsarClientException {
        Argument messageBodyType;
        Argument keyClass;
        if (KeyValue.class.isAssignableFrom(readerArgument.getType())) {
            keyClass = readerArgument.getTypeParameters()[0];
            messageBodyType = readerArgument.getTypeParameters()[1];
        } else {
            messageBodyType = Message.class.isAssignableFrom(readerArgument.getType()) ? (Argument)readerArgument.getFirstTypeVariable().orElseThrow(() -> new ConfigurationException("Reader methods must return non-raw Message")) : readerArgument;
            keyClass = null;
        }
        String name = annotation.stringValue("readerName").orElse(declaredName);
        TopicResolver.TopicResolved topicResolved = TopicResolver.extractTopic(annotation, name);
        String readerId = this.topicResolver.generateIdFromMessagingClientName(name, topicResolved);
        if (this.readers.containsKey(readerId)) {
            return this.readers.get(readerId);
        }
        Schema<?> schema = this.simpleSchemaResolver.decideSchema(messageBodyType, keyClass, annotation, target);
        String topic = this.topicResolver.resolve(topicResolved.getTopic());
        MessageId startMessageId = (Boolean)annotation.getRequiredValue("startMessageLatest", Boolean.TYPE) != false ? MessageId.latest : MessageId.earliest;
        Optional subscriptionName = annotation.stringValue("subscriptionName");
        ReaderBuilder readerBuilder = this.pulsarClient.newReader(schema).startMessageId(startMessageId).readerName(readerId).topic(topic);
        subscriptionName.ifPresent(arg_0 -> ((ReaderBuilder)readerBuilder).subscriptionName(arg_0));
        Reader reader = readerBuilder.create();
        this.readers.put(readerId, reader);
        return reader;
    }

    @Override
    public void close() {
        for (Reader<?> reader : this.readers.values()) {
            try {
                reader.close();
            }
            catch (Exception e) {
                LOG.warn("Error shutting down Pulsar reader: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.readers.clear();
    }

    @Override
    public Reader<?> getReader(String identifier) {
        return this.readers.get(identifier);
    }

    @Override
    public Collection<Reader<?>> getReaders() {
        return this.readers.values();
    }
}

